/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Iterator;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeTree;

@Incubating(since="7.0.0")
public class NoFinalizedLocalVariables
extends Recipe {
    public String getDisplayName() {
        return "Don't use final on local variables";
    }

    public String getDescription() {
        return "Remove the `final` modifier keyword from local variables regardless of whether they are used within a local class or an anonymous class.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations mv = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                if (!mv.hasModifier(J.Modifier.Type.Final)) {
                    return mv;
                }
                Tree parent = (Tree)this.getCursor().getParentTreeCursor().getValue();
                if (parent instanceof J.MethodDeclaration || parent instanceof J.Lambda) {
                    return this.removeFinal(mv);
                }
                Iterator cursorPath = this.getCursor().getPath();
                while (cursorPath.hasNext()) {
                    Object next = cursorPath.next();
                    if (!(next instanceof J.Block)) continue;
                    while (cursorPath.hasNext()) {
                        next = cursorPath.next();
                        if (next instanceof J.ClassDeclaration || next instanceof J.NewClass) {
                            return mv;
                        }
                        if (!(next instanceof J.MethodDeclaration)) continue;
                        return this.removeFinal(mv);
                    }
                    break block0;
                }
                return mv;
            }

            private J.VariableDeclarations removeFinal(J.VariableDeclarations mv) {
                J.VariableDeclarations v = mv.withModifiers(ListUtils.map((List)mv.getModifiers(), m -> m.getType() == J.Modifier.Type.Final ? null : m));
                if (v.getModifiers().isEmpty() && v.getTypeExpression() != null) {
                    v = v.withTypeExpression((TypeTree)v.getTypeExpression().withPrefix(v.getTypeExpression().getPrefix().withWhitespace(v.getLeadingAnnotations().isEmpty() ? "" : " ")));
                }
                return v;
            }
        };
    }
}

