/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class UnnecessaryPrimitiveAnnotations
extends Recipe {
    private static final AnnotationMatcher CHECK_FOR_NULL_ANNOTATION_MATCHER = new AnnotationMatcher("@javax.annotation.CheckForNull");
    private static final AnnotationMatcher NULLABLE_ANNOTATION_MATCHER = new AnnotationMatcher("@javax.annotation.Nullable");

    public String getDisplayName() {
        return "Remove `@Nullable` and `@CheckForNull` annotations from primitives";
    }

    public String getDescription() {
        return "Primitives can't be null anyway, so these annotations are not useful in this context.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S4682");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("javax.annotation.CheckForNull", Boolean.valueOf(false)), new UsesType("javax.annotation.Nullable", Boolean.valueOf(false))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
                if (md.getReturnTypeExpression() != null && !(md.getReturnTypeExpression() instanceof J.ArrayType) && md.getReturnTypeExpression().getType() instanceof JavaType.Primitive) {
                    md = (J.MethodDeclaration)this.maybeAutoFormat((J)md, (J)md.withLeadingAnnotations(this.filterAnnotations(md.getLeadingAnnotations())), ctx);
                }
                return md;
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations varDecls = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                if (varDecls.getType() instanceof JavaType.Primitive && varDecls.getVariables().stream().noneMatch(nv -> nv.getType() instanceof JavaType.Array)) {
                    varDecls = varDecls.withLeadingAnnotations(this.filterAnnotations(varDecls.getLeadingAnnotations()));
                }
                return varDecls;
            }

            private List<J.Annotation> filterAnnotations(List<J.Annotation> annotations) {
                return ListUtils.map(annotations, anno -> {
                    if (NULLABLE_ANNOTATION_MATCHER.matches(anno) || CHECK_FOR_NULL_ANNOTATION_MATCHER.matches(anno)) {
                        this.maybeRemoveImport("javax.annotation.CheckForNull");
                        this.maybeRemoveImport("javax.annotation.Nullable");
                        return null;
                    }
                    return anno;
                });
            }
        });
    }
}

