/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.terraform;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.hcl.HclTemplate;
import org.openrewrite.hcl.HclVisitor;
import org.openrewrite.hcl.tree.BodyContent;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.template.SourceTemplate;
import org.openrewrite.terraform.TerraformResource;

public final class AddConfiguration
extends Recipe {
    @Option(displayName="Resource name", description="A Terraform resource name, without the quotes.", example="aws_ebs_volume")
    private final String resourceName;
    @Option(displayName="Body content", description="Terraform to insert if an attribute with the same name or block with the same 'type' is not found.", example="encrypted = true")
    private final String content;

    public String getDisplayName() {
        return "Add Terraform configuration";
    }

    public String getDescription() {
        return "If the configuration has a different value, leave it alone. If it is missing, add it.";
    }

    protected HclVisitor<ExecutionContext> getVisitor() {
        return new HclVisitor<ExecutionContext>(){

            public Hcl visitBlock(Hcl.Block block, ExecutionContext executionContext) {
                Hcl.Block b = block;
                if (TerraformResource.isResource(b, AddConfiguration.this.resourceName)) {
                    String contentName;
                    List body = (b = (Hcl.Block)b.withTemplate((SourceTemplate)HclTemplate.builder(() -> ((Cursor)this.getCursor()).getParent(), (String)AddConfiguration.this.content).build(), b.getCoordinates().last(), new Object[0])).getBody();
                    BodyContent parsedContent = (BodyContent)body.get(body.size() - 1);
                    if (parsedContent instanceof Hcl.Attribute) {
                        contentName = ((Hcl.Attribute)parsedContent).getSimpleName();
                    } else {
                        Hcl.Identifier type = ((Hcl.Block)parsedContent).getType();
                        assert (type != null);
                        contentName = type.getName();
                    }
                    for (int i = 0; i < body.size() - 1; ++i) {
                        Hcl.Block siblingBlock;
                        BodyContent content = (BodyContent)body.get(i);
                        if (content instanceof Hcl.Attribute && ((Hcl.Attribute)content).getSimpleName().equals(contentName)) {
                            return block;
                        }
                        if (!(content instanceof Hcl.Block) || (siblingBlock = (Hcl.Block)content).getType() == null || !siblingBlock.getType().getName().equals(contentName)) continue;
                        return block;
                    }
                }
                return b;
            }
        };
    }

    public AddConfiguration(String resourceName, String content) {
        this.resourceName = resourceName;
        this.content = content;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getContent() {
        return this.content;
    }

    public String toString() {
        return "AddConfiguration(resourceName=" + this.getResourceName() + ", content=" + this.getContent() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddConfiguration)) {
            return false;
        }
        AddConfiguration other = (AddConfiguration)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$resourceName = this.getResourceName();
        String other$resourceName = other.getResourceName();
        if (this$resourceName == null ? other$resourceName != null : !this$resourceName.equals(other$resourceName)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $resourceName = this.getResourceName();
        result = result * 59 + ($resourceName == null ? 43 : $resourceName.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }
}

