/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.terraform.terraform012;

import java.util.ArrayList;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.hcl.HclVisitor;
import org.openrewrite.hcl.tree.Expression;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.HclContainer;
import org.openrewrite.hcl.tree.HclLeftPadded;
import org.openrewrite.hcl.tree.HclRightPadded;
import org.openrewrite.hcl.tree.Space;
import org.openrewrite.marker.Markers;

@Incubating(since="0.7.0")
public class UpgradeExpressions
extends Recipe {
    public String getDisplayName() {
        return "Upgrade expressions";
    }

    public String getDescription() {
        return "Update expressions using string interpolation template syntax (`\"${var.variable}\"`) to using first-class expression syntax (`var.variable`).";
    }

    protected HclVisitor<ExecutionContext> getVisitor() {
        return new UpgradeExpression();
    }

    private static class UpgradeVariableTypes
    extends HclVisitor<ExecutionContext> {
        private UpgradeVariableTypes() {
        }

        public Hcl visitBlock(Hcl.Block block, ExecutionContext ctx) {
            if (block.getType() != null && block.getType().getName().equals("variable")) {
                return super.visitBlock(block, (Object)ctx);
            }
            return block;
        }

        public Hcl visitAttribute(Hcl.Attribute attribute, ExecutionContext ctx) {
            Expression first;
            Expression e;
            Hcl.Attribute attr = (Hcl.Attribute)super.visitAttribute(attribute, (Object)ctx);
            if (attr.getSimpleName().equals("type") && (e = attr.getValue()) instanceof Hcl.QuotedTemplate && !((Hcl.QuotedTemplate)e).getExpressions().isEmpty() && (first = (Expression)((Hcl.QuotedTemplate)e).getExpressions().get(0)) instanceof Hcl.Literal) {
                Hcl.Literal l = (Hcl.Literal)first;
                if (l.getValueSource().equals("list")) {
                    l = l.withValueSource("list(string)");
                } else if (l.getValueSource().equals("map")) {
                    l = l.withValueSource("map(string)");
                }
                return attr.withValue((Expression)l.withPrefix(e.getPrefix()));
            }
            return attr;
        }
    }

    private static class UpgradeExpression
    extends HclVisitor<ExecutionContext> {
        private UpgradeExpression() {
        }

        public Hcl visitConfigFile(Hcl.ConfigFile configFile, ExecutionContext ctx) {
            this.doAfterVisit((TreeVisitor)new UpgradeVariableTypes());
            return super.visitConfigFile(configFile, (Object)ctx);
        }

        public Hcl visitQuotedTemplate(Hcl.QuotedTemplate template, ExecutionContext ctx) {
            Expression e;
            if (template.getExpressions().size() == 1 && (e = (Expression)template.getExpressions().get(0)) instanceof Hcl.TemplateInterpolation) {
                Hcl.TemplateInterpolation t = (Hcl.TemplateInterpolation)e;
                return t.getExpression().withPrefix(template.getPrefix());
            }
            return super.visitQuotedTemplate(template, (Object)ctx);
        }

        public Hcl visitFunctionCall(Hcl.FunctionCall functionCall, ExecutionContext ctx) {
            Hcl.FunctionCall f = (Hcl.FunctionCall)super.visitFunctionCall(functionCall, (Object)ctx);
            switch (f.getName().getName()) {
                case "list": {
                    return new Hcl.Tuple(Tree.randomId(), f.getPrefix(), Markers.EMPTY, f.getPadding().getArguments());
                }
                case "map": {
                    if (f.getVariables().isEmpty() || f.getVariables().get(0) instanceof Hcl.Empty) {
                        return new Hcl.ObjectValue(Tree.randomId(), f.getPrefix(), Markers.EMPTY, f.getPadding().getArguments());
                    }
                    if (f.getVariables().size() % 2 != 0) break;
                    ArrayList<HclRightPadded> elms = new ArrayList<HclRightPadded>();
                    for (int i = 0; i < f.getVariables().size(); i += 2) {
                        Expression e0 = (Expression)f.getVariables().get(i);
                        Expression e1 = (Expression)f.getVariables().get(i + 1);
                        HclRightPadded hclRightPadded = HclRightPadded.build((Object)new Hcl.Attribute(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Expression)e0.withPrefix(Space.EMPTY), HclLeftPadded.build((Object)Hcl.Attribute.Type.Assignment), (Expression)e1.withPrefix(Space.EMPTY)));
                        elms.add(hclRightPadded);
                    }
                    return new Hcl.ObjectValue(Tree.randomId(), f.getPrefix(), Markers.EMPTY, HclContainer.build(elms));
                }
                case "lookup": {
                    if (f.getVariables().size() != 2) break;
                    return new Hcl.Index(Tree.randomId(), f.getPrefix(), Markers.EMPTY, (Expression)f.getVariables().get(0), new Hcl.Index.Position(Tree.randomId(), Space.EMPTY, Markers.EMPTY, HclRightPadded.build((Object)((Expression)((Expression)f.getVariables().get(1)).withPrefix(Space.EMPTY)))));
                }
                case "element": {
                    break;
                }
                case "__builtin_BoolToString": {
                    break;
                }
                case "__builtin_FloatToString": {
                    break;
                }
                case "__builtin_IntToString": {
                    break;
                }
                case "__builtin_StringToInt": {
                    break;
                }
                case "__builtin_StringToFloat": {
                    break;
                }
                case "__builtin_StringToBool": {
                    break;
                }
            }
            return f;
        }
    }
}

