/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.terraform.search;

import java.time.Duration;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.hcl.HclVisitor;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.terraform.TerraformResource;

public final class FindResource
extends Recipe {
    @Option(displayName="Resource name", description="A Terraform resource name, without the quotes.", example="aws_ebs_volume")
    private final String resourceName;

    public String getDisplayName() {
        return "Find Terraform resource";
    }

    public String getDescription() {
        return "Find a Terraform resource by resource type.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public HclVisitor<ExecutionContext> getVisitor() {
        return new HclVisitor<ExecutionContext>(){

            public Hcl visitBlock(Hcl.Block block, ExecutionContext ctx) {
                Hcl.Block b = block;
                if (TerraformResource.isResource(b, FindResource.this.resourceName)) {
                    b = (Hcl.Block)SearchResult.found((Tree)b);
                }
                return b;
            }
        };
    }

    public FindResource(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String toString() {
        return "FindResource(resourceName=" + this.getResourceName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindResource)) {
            return false;
        }
        FindResource other = (FindResource)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$resourceName = this.getResourceName();
        String other$resourceName = other.getResourceName();
        return !(this$resourceName == null ? other$resourceName != null : !this$resourceName.equals(other$resourceName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindResource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $resourceName = this.getResourceName();
        result = result * 59 + ($resourceName == null ? 43 : $resourceName.hashCode());
        return result;
    }
}

