/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.terraform;

import java.time.Duration;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.hcl.HclIsoVisitor;
import org.openrewrite.hcl.tree.Expression;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.terraform.TerraformResource;

public final class SecureRandom
extends Recipe {
    private static final int DEFAULT_MINIMUM = 20;
    @Option(displayName="Byte length", description="The minimum byte length to use.", required=false)
    private final @Nullable Integer byteLength;

    public String getDisplayName() {
        return "Use a long enough byte length for `random` resources";
    }

    public String getDescription() {
        return "Use a long enough byte length for `random` resources.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new HclIsoVisitor<ExecutionContext>(){

            public Hcl.Attribute visitAttribute(Hcl.Attribute attribute, ExecutionContext ctx) {
                Hcl parent = (Hcl)this.getCursor().getParentOrThrow().getValue();
                if (parent instanceof Hcl.Block && TerraformResource.isResource((Hcl.Block)parent, "random_id") && "byte_length".equals(attribute.getSimpleName()) && attribute.getValue() instanceof Hcl.Literal) {
                    int minLength;
                    Hcl.Literal value = (Hcl.Literal)attribute.getValue();
                    int n = minLength = SecureRandom.this.byteLength == null ? 20 : SecureRandom.this.byteLength;
                    if (Integer.parseInt(value.getValueSource()) < minLength) {
                        return attribute.withValue((Expression)value.withValue((Object)minLength).withValueSource(Integer.toString(minLength)));
                    }
                }
                return attribute;
            }
        };
    }

    @Generated
    public SecureRandom(@Nullable Integer byteLength) {
        this.byteLength = byteLength;
    }

    @Generated
    public @Nullable Integer getByteLength() {
        return this.byteLength;
    }

    @Generated
    public String toString() {
        return "SecureRandom(byteLength=" + this.getByteLength() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecureRandom)) {
            return false;
        }
        SecureRandom other = (SecureRandom)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$byteLength = this.getByteLength();
        Integer other$byteLength = other.getByteLength();
        return !(this$byteLength == null ? other$byteLength != null : !((Object)this$byteLength).equals(other$byteLength));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SecureRandom;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $byteLength = this.getByteLength();
        result = result * 59 + ($byteLength == null ? 43 : ((Object)$byteLength).hashCode());
        return result;
    }
}

