/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.terraform.search;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.hcl.HclIsoVisitor;
import org.openrewrite.hcl.JsonPathMatcher;
import org.openrewrite.hcl.tree.Expression;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.terraform.table.RequiredProviders;

public final class FindRequiredProvider
extends Recipe {
    private final transient RequiredProviders requiredProviders = new RequiredProviders(this);
    @Option(displayName="Source", description="The source of the required provider, e.g. `hashicorp/aws`.", example="hashicorp/aws", required=false)
    private final @Nullable String source;

    public String getDisplayName() {
        return "Find required providers";
    }

    public String getDescription() {
        return "Find `required_providers` blocks in Terraform configuration files. Produces a data table of the provider names and their versions.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new HclIsoVisitor<ExecutionContext>(){

            public Hcl.Attribute visitAttribute(Hcl.Attribute attribute, ExecutionContext ctx) {
                Hcl.Attribute attr = super.visitAttribute(attribute, (Object)ctx);
                if (new JsonPathMatcher("$.terraform.required_providers").matches(this.getCursor().getParentOrThrow())) {
                    String name = attr.getSimpleName();
                    String sourceValue = this.extractVersion(attr.getValue(), "source");
                    if (FindRequiredProvider.this.source != null && !FindRequiredProvider.this.source.equals(sourceValue)) {
                        return attr;
                    }
                    String versionValue = this.extractVersion(attr.getValue(), "version");
                    if (sourceValue != null && versionValue != null) {
                        FindRequiredProvider.this.requiredProviders.insertRow(ctx, new RequiredProviders.RequiredProvider(name, sourceValue, versionValue));
                    }
                    return (Hcl.Attribute)SearchResult.found((Tree)attr);
                }
                return attr;
            }

            private @Nullable String extractVersion(Expression value, String attributeName) {
                if (value instanceof Hcl.ObjectValue) {
                    Hcl.ObjectValue objectValue = (Hcl.ObjectValue)value;
                    for (Expression expr : objectValue.getAttributes()) {
                        Hcl.Attribute attr;
                        if (!(expr instanceof Hcl.Attribute) || !attributeName.equals((attr = (Hcl.Attribute)expr).getSimpleName())) continue;
                        Expression attrValue = attr.getValue();
                        if (attrValue instanceof Hcl.QuotedTemplate) {
                            Hcl.QuotedTemplate qt = (Hcl.QuotedTemplate)attrValue;
                            if (qt.getExpressions().isEmpty() || !(qt.getExpressions().get(0) instanceof Hcl.Literal)) continue;
                            return ((Hcl.Literal)qt.getExpressions().get(0)).getValueSource();
                        }
                        if (!(attrValue instanceof Hcl.Literal)) continue;
                        return ((Hcl.Literal)attrValue).getValueSource();
                    }
                }
                return null;
            }
        };
    }

    @Generated
    public FindRequiredProvider(@Nullable String source) {
        this.source = source;
    }

    @Generated
    public RequiredProviders getRequiredProviders() {
        return this.requiredProviders;
    }

    @Generated
    public @Nullable String getSource() {
        return this.source;
    }

    @Generated
    public String toString() {
        return "FindRequiredProvider(requiredProviders=" + (Object)((Object)this.getRequiredProviders()) + ", source=" + this.getSource() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindRequiredProvider)) {
            return false;
        }
        FindRequiredProvider other = (FindRequiredProvider)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        return !(this$source == null ? other$source != null : !this$source.equals(other$source));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindRequiredProvider;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        return result;
    }
}

