/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.terraform.table;

import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.terraform.search.FindRequiredProvider;

public class RequiredProviders
extends DataTable<RequiredProvider> {
    public RequiredProviders(FindRequiredProvider findRequiredProvider) {
        super((Recipe)findRequiredProvider, "Required providers", "A list of required providers in the Terraform configuration.");
    }

    public static final class RequiredProvider {
        @Column(displayName="Configuration name", description="The name of the configuration, e.g. `aws`.")
        private final String name;
        @Column(displayName="Source", description="The source of the required provider, e.g. `hashicorp/aws`.")
        private final String source;
        @Column(displayName="Version", description="The version constraint for the provider, e.g. `~> 3.0`.")
        private final String version;

        @Generated
        public RequiredProvider(String name, String source, String version) {
            this.name = name;
            this.source = source;
            this.version = version;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getSource() {
            return this.source;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String toString() {
            return "RequiredProviders.RequiredProvider(name=" + this.getName() + ", source=" + this.getSource() + ", version=" + this.getVersion() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequiredProvider)) {
                return false;
            }
            RequiredProvider other = (RequiredProvider)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }
    }
}

