/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.AddAnnotation;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.AutoFormat;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

@AutoConfigure
public class ChangeTestAnnotation
extends JavaIsoRefactorVisitor {
    public ChangeTestAnnotation() {
        this.setCursoringOn();
    }

    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu) {
        ChangeType changeType = new ChangeType();
        changeType.setType("org.junit.Test");
        changeType.setTargetType("org.junit.jupiter.api.Test");
        this.andThen((RefactorVisitor)changeType);
        return super.visitCompilationUnit(cu);
    }

    public J.MethodDecl visitMethod(J.MethodDecl method) {
        J.MethodDecl m = super.visitMethod(method);
        boolean changed = false;
        ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>(m.getAnnotations());
        int annotationsSize = annotations.size();
        for (int i = 0; i < annotationsSize; ++i) {
            J.Annotation a = (J.Annotation)annotations.get(i);
            if (!TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.Test")) continue;
            annotations.set(i, a.withArgs(null));
            if (a.getArgs() == null) continue;
            List args = a.getArgs().getArgs();
            for (Expression arg : args) {
                if (arg instanceof J.Assign) {
                    J.Assign assign = (J.Assign)arg;
                    String assignParamName = ((J.Ident)assign.getVariable()).getSimpleName();
                    Expression e = assign.getAssignment();
                    if (m.getBody() == null) continue;
                    if (assignParamName.equals("expected")) {
                        List statements = m.getBody().getStatements();
                        boolean isSingleExpression = statements.size() == 1 && statements.get(0) instanceof Expression;
                        Object assertBlock = isSingleExpression ? (Statement)((Statement)statements.get(0)).withPrefix(" ") : new J.Block(Tree.randomId(), null, statements, Formatting.format((String)" "), new J.Block.End(Tree.randomId(), Formatting.format((String)"\n")));
                        J.MethodInvocation assertThrows = new J.MethodInvocation(Tree.randomId(), null, null, J.Ident.build((UUID)Tree.randomId(), (String)"assertThrows", (JavaType)JavaType.Primitive.Void, (Formatting)Formatting.EMPTY), new J.MethodInvocation.Arguments(Tree.randomId(), Arrays.asList((Expression)e.withFormatting(Formatting.EMPTY), new J.Lambda(Tree.randomId(), new J.Lambda.Parameters(Tree.randomId(), true, Collections.emptyList()), new J.Lambda.Arrow(Tree.randomId(), Formatting.format((String)" ")), (Tree)assertBlock, (JavaType)JavaType.Primitive.Void, Formatting.format((String)" "))), Formatting.EMPTY), JavaType.Method.build((JavaType.FullyQualified)JavaType.Class.build((String)"org.junit.jupiter.api.Assertions"), (String)"assertThrows", null, (JavaType.Method.Signature)new JavaType.Method.Signature((JavaType)new JavaType.GenericTypeVariable("T", JavaType.Class.build((String)"java.lang.Throwable")), Arrays.asList(JavaType.Class.build((String)"java.lang.Class"), JavaType.Class.build((String)"org.junit.jupiter.api.function.Executable"))), Arrays.asList("arg0", "arg1"), new HashSet<Flag>(Arrays.asList(Flag.Public, Flag.Static))), Formatting.format((String)"\n"));
                        AddImport addAssertThrows = new AddImport();
                        addAssertThrows.setType("org.junit.jupiter.api.Assertions");
                        addAssertThrows.setStaticMethod("assertThrows");
                        addAssertThrows.setOnlyIfReferenced(false);
                        this.andThen((RefactorVisitor)addAssertThrows);
                        this.andThen((RefactorVisitor)new AutoFormat(new J[]{assertThrows}));
                        this.andThen((RefactorVisitor)new AutoFormat(new J[]{assertBlock}));
                        m = method.withBody(m.getBody().withStatements(Collections.singletonList(assertThrows)));
                    } else if (assignParamName.equals("timeout")) {
                        AddAnnotation.Scoped aa = new AddAnnotation.Scoped((Tree)m, "org.junit.jupiter.api.Timeout", new Expression[]{(Expression)e.withFormatting(Formatting.EMPTY)});
                        this.andThen((RefactorVisitor)aa);
                        this.andThen((RefactorVisitor)new AutoFormat(new J[]{m}));
                    }
                }
                changed = true;
            }
        }
        if (changed) {
            m = m.withAnnotations(annotations);
        }
        return m;
    }
}

