/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.AutoConfigure;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.AutoFormat;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.testing.junit5.AssertionsBuilder;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

@AutoConfigure
public class ExpectedExceptionToAssertThrows
extends JavaIsoRefactorVisitor {
    private static final String ExpectedExceptionFqn = "org.junit.rules.ExpectedException";

    public ExpectedExceptionToAssertThrows() {
        this.setCursoringOn();
    }

    public J.ClassDecl visitClassDecl(J.ClassDecl classDecl) {
        J.ClassDecl cd = super.visitClassDecl(classDecl);
        List expectedExceptionFields = classDecl.findFields(ExpectedExceptionFqn);
        if (expectedExceptionFields.size() > 0) {
            ArrayList statements = new ArrayList(classDecl.getBody().getStatements());
            statements.removeAll(expectedExceptionFields);
            cd = cd.withBody(classDecl.getBody().withStatements(statements));
        }
        return cd;
    }

    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method) {
        J.MethodDecl enclosing;
        if (method.getType() != null && method.getType().getDeclaringType().getFullyQualifiedName().equals(ExpectedExceptionFqn) && (enclosing = (J.MethodDecl)this.getCursor().firstEnclosing(J.MethodDecl.class)) != null) {
            this.andThen((RefactorVisitor)new Scoped(enclosing, method));
        }
        return super.visitMethodInvocation(method);
    }

    private static class Scoped
    extends JavaIsoRefactorVisitor {
        private final J.MethodDecl enclosingMethodDecl;
        private final J.MethodInvocation expectedExceptionMethod;

        private Scoped(J.MethodDecl enclosingMethodDecl, J.MethodInvocation expectedExceptionMethod) {
            this.enclosingMethodDecl = enclosingMethodDecl;
            this.expectedExceptionMethod = expectedExceptionMethod;
        }

        public J.MethodDecl visitMethod(J.MethodDecl m) {
            if (!this.enclosingMethodDecl.isScope((Tree)m) || m.getBody() == null) {
                return m;
            }
            List args = this.expectedExceptionMethod.getArgs().getArgs();
            if (args.size() != 1) {
                return m;
            }
            Expression expectedException = (Expression)args.get(0);
            JavaType.FullyQualified argType = TypeUtils.asFullyQualified((JavaType)expectedException.getType());
            if (argType == null || !argType.getFullyQualifiedName().equals("java.lang.Class")) {
                return m;
            }
            ArrayList<Statement> statements = new ArrayList<Statement>(m.getBody().getStatements());
            statements.remove(this.expectedExceptionMethod);
            J.MethodInvocation assertThrows = AssertionsBuilder.assertThrows(expectedException, statements);
            AddImport addAssertThrows = new AddImport();
            addAssertThrows.setType("org.junit.jupiter.api.Assertions");
            addAssertThrows.setStaticMethod("assertThrows");
            addAssertThrows.setOnlyIfReferenced(false);
            this.andThen((RefactorVisitor)addAssertThrows);
            this.andThen((RefactorVisitor)new AutoFormat(new J[]{assertThrows}));
            this.maybeRemoveImport("org.junit.Rule");
            this.maybeRemoveImport(ExpectedExceptionToAssertThrows.ExpectedExceptionFqn);
            m = m.withBody(m.getBody().withStatements(Collections.singletonList(assertThrows)));
            return m;
        }
    }
}

