/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;

@AutoConfigure
public class SpringRunnerToSpringExtension
extends JavaIsoRefactorVisitor {
    private static final JavaType.Class runWithType = JavaType.Class.build((String)"org.junit.runner.RunWith");
    private static final J.Ident runWithIdent = J.Ident.build((UUID)Tree.randomId(), (String)"RunWith", (JavaType)runWithType, (Formatting)Formatting.EMPTY);
    private static final JavaType.Class springRunnerType = JavaType.Class.build((String)"org.springframework.test.context.junit4.SpringRunner");
    private static final JavaType.Class extendWithType = JavaType.Class.build((String)"org.junit.jupiter.api.extension.ExtendWith");
    private static final J.Ident extendWithIdent = J.Ident.build((UUID)Tree.randomId(), (String)"ExtendWith", (JavaType)extendWithType, (Formatting)Formatting.EMPTY);
    private static final JavaType.Class springExtensionType = JavaType.Class.build((String)"org.springframework.test.context.junit.jupiter.SpringExtension");
    private static final J.Annotation runWithSpringRunnerAnnotation = new J.Annotation(Tree.randomId(), (NameTree)runWithIdent, new J.Annotation.Arguments(Tree.randomId(), Collections.singletonList(new J.FieldAccess(Tree.randomId(), (Expression)J.Ident.build((UUID)Tree.randomId(), (String)"SpringRunner", (JavaType)springRunnerType, (Formatting)Formatting.EMPTY), J.Ident.build((UUID)Tree.randomId(), (String)"class", null, (Formatting)Formatting.EMPTY), (JavaType)JavaType.Class.build((String)"java.lang.Class"), Formatting.EMPTY)), Formatting.EMPTY), Formatting.EMPTY);
    private static final JavaType.Class springJUnit4ClassRunnerType = JavaType.Class.build((String)"org.springframework.test.context.junit4.SpringJUnit4ClassRunner");
    private static final J.Annotation runWithSpringJUnit4ClassRunnerAnnotation = new J.Annotation(Tree.randomId(), (NameTree)runWithIdent, new J.Annotation.Arguments(Tree.randomId(), Collections.singletonList(new J.FieldAccess(Tree.randomId(), (Expression)J.Ident.build((UUID)Tree.randomId(), (String)"SpringJUnit4ClassRunner", (JavaType)springJUnit4ClassRunnerType, (Formatting)Formatting.EMPTY), J.Ident.build((UUID)Tree.randomId(), (String)"class", null, (Formatting)Formatting.EMPTY), (JavaType)JavaType.Class.build((String)"java.lang.Class"), Formatting.EMPTY)), Formatting.EMPTY), Formatting.EMPTY);
    private static final J.Annotation extendWithSpringExtensionAnnotation = new J.Annotation(Tree.randomId(), (NameTree)extendWithIdent, new J.Annotation.Arguments(Tree.randomId(), Collections.singletonList(new J.FieldAccess(Tree.randomId(), (Expression)J.Ident.build((UUID)Tree.randomId(), (String)"SpringExtension", (JavaType)springExtensionType, (Formatting)Formatting.EMPTY), J.Ident.build((UUID)Tree.randomId(), (String)"class", null, (Formatting)Formatting.EMPTY), (JavaType)JavaType.Class.build((String)"java.lang.Class"), Formatting.EMPTY)), Formatting.EMPTY), Formatting.EMPTY);

    public SpringRunnerToSpringExtension() {
        this.setCursoringOn();
    }

    public J.ClassDecl visitClassDecl(J.ClassDecl cd) {
        if (cd.getAnnotations().stream().filter(this::shouldReplaceAnnotation).findAny().isPresent()) {
            List annotations = cd.getAnnotations().stream().map(this::springRunnerToSpringExtension).collect(Collectors.toList());
            return cd.withAnnotations(annotations);
        }
        return cd;
    }

    private J.Annotation springRunnerToSpringExtension(J.Annotation maybeSpringRunner) {
        if (!((Boolean)new SemanticallyEqual((Tree)runWithSpringRunnerAnnotation).visit((Tree)maybeSpringRunner)).booleanValue() && !((Boolean)new SemanticallyEqual((Tree)runWithSpringJUnit4ClassRunnerAnnotation).visit((Tree)maybeSpringRunner)).booleanValue()) {
            return maybeSpringRunner;
        }
        Formatting originalFormatting = maybeSpringRunner.getFormatting();
        J.ClassDecl parent = (J.ClassDecl)this.getCursor().firstEnclosing(J.ClassDecl.class);
        assert (parent != null);
        J.Annotation extendWithSpringExtension = extendWithSpringExtensionAnnotation.withFormatting(originalFormatting);
        this.maybeAddImport((JavaType.FullyQualified)extendWithType);
        this.maybeAddImport((JavaType.FullyQualified)springExtensionType);
        this.maybeRemoveImport((JavaType.FullyQualified)springRunnerType);
        this.maybeRemoveImport((JavaType.FullyQualified)springJUnit4ClassRunnerType);
        this.maybeRemoveImport((JavaType.FullyQualified)runWithType);
        return extendWithSpringExtension;
    }

    private boolean shouldReplaceAnnotation(J.Annotation maybeSpringRunner) {
        return (Boolean)new SemanticallyEqual((Tree)runWithSpringRunnerAnnotation).visit((Tree)maybeSpringRunner) != false || (Boolean)new SemanticallyEqual((Tree)runWithSpringJUnit4ClassRunnerAnnotation).visit((Tree)maybeSpringRunner) != false;
    }
}

