/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.AddAnnotation;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.AutoFormat;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.testing.junit5.AssertionsBuilder;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

@AutoConfigure
public class UpdateTestAnnotation
extends JavaIsoRefactorVisitor {
    public UpdateTestAnnotation() {
        this.setCursoringOn();
    }

    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu) {
        ChangeType changeType = new ChangeType();
        changeType.setType("org.junit.Test");
        changeType.setTargetType("org.junit.jupiter.api.Test");
        this.andThen((RefactorVisitor)changeType);
        return super.visitCompilationUnit(cu);
    }

    public J.MethodDecl visitMethod(J.MethodDecl method) {
        J.MethodDecl m = super.visitMethod(method);
        boolean changed = false;
        ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>(m.getAnnotations());
        int annotationsSize = annotations.size();
        for (int i = 0; i < annotationsSize; ++i) {
            J.Annotation a = (J.Annotation)annotations.get(i);
            if (!TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.Test")) continue;
            annotations.set(i, a.withArgs(null));
            if (a.getArgs() == null) continue;
            List args = a.getArgs().getArgs();
            for (Expression arg : args) {
                if (arg instanceof J.Assign) {
                    J.Assign assign = (J.Assign)arg;
                    String assignParamName = ((J.Ident)assign.getVariable()).getSimpleName();
                    Expression e = assign.getAssignment();
                    if (m.getBody() == null) continue;
                    if (assignParamName.equals("expected")) {
                        List statements = m.getBody().getStatements();
                        J.MethodInvocation assertThrows = AssertionsBuilder.assertThrows(e, statements);
                        AddImport addAssertThrows = new AddImport();
                        addAssertThrows.setType("org.junit.jupiter.api.Assertions");
                        addAssertThrows.setStaticMethod("assertThrows");
                        addAssertThrows.setOnlyIfReferenced(false);
                        this.andThen((RefactorVisitor)addAssertThrows);
                        this.andThen((RefactorVisitor)new AutoFormat(new J[]{assertThrows}));
                        m = method.withBody(m.getBody().withStatements(Collections.singletonList(assertThrows)));
                    } else if (assignParamName.equals("timeout")) {
                        AddAnnotation.Scoped aa = new AddAnnotation.Scoped((Tree)m, "org.junit.jupiter.api.Timeout", new Expression[]{(Expression)e.withFormatting(Formatting.EMPTY)});
                        this.andThen((RefactorVisitor)aa);
                        this.andThen((RefactorVisitor)new AutoFormat(new J[]{m}));
                    }
                }
                changed = true;
            }
        }
        if (changed) {
            m = m.withAnnotations(annotations);
        }
        return m;
    }
}

