/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junitassertj;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.AutoFormat;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@AutoConfigure
public class AssertTrueToAssertThat
extends JavaIsoRefactorVisitor {
    private static final String JUNIT_QUALIFIED_ASSERTIONS_CLASS = "org.junit.jupiter.api.Assertions";
    private static final String JUNIT_ASSERT_TRUE_METHOD = "assertTrue";
    private static final String ASSERTJ_QUALIFIED_ASSERTIONS_CLASS = "org.assertj.core.api.Assertions";
    private static final String ASSERTJ_QUALIFIED_BOOLEAN_ASSERT_CLASS = "org.assertj.core.api.AbstractBooleanAssert";
    private static final String ASSERTJ_ASSERT_THAT_METHOD = "assertThat";
    private static final MethodMatcher assertTrueMatcher = new MethodMatcher("org.junit.jupiter.api.Assertions assertTrue(boolean, ..)");
    private static final JavaType.Method assertThatMethodDeclaration;

    public AssertTrueToAssertThat() {
        this.setCursoringOn();
    }

    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu) {
        this.maybeRemoveImport(JUNIT_QUALIFIED_ASSERTIONS_CLASS);
        return super.visitCompilationUnit(cu);
    }

    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method) {
        J.MethodInvocation original = super.visitMethodInvocation(method);
        if (!assertTrueMatcher.matches(method)) {
            return original;
        }
        List originalArgs = original.getArgs().getArgs();
        Expression condition = (Expression)originalArgs.get(0);
        Expression message = originalArgs.size() == 2 ? (Expression)originalArgs.get(1) : null;
        J.MethodInvocation assertSelect = new J.MethodInvocation(Tree.randomId(), null, null, J.Ident.build((UUID)Tree.randomId(), (String)ASSERTJ_ASSERT_THAT_METHOD, (JavaType)JavaType.Primitive.Void, (Formatting)Formatting.EMPTY), new J.MethodInvocation.Arguments(Tree.randomId(), Collections.singletonList(condition), Formatting.EMPTY), assertThatMethodDeclaration, Formatting.EMPTY);
        if (message != null) {
            assertSelect = new J.MethodInvocation(Tree.randomId(), (Expression)assertSelect, null, J.Ident.build((UUID)Tree.randomId(), (String)"withFailMessage", null, (Formatting)Formatting.EMPTY), new J.MethodInvocation.Arguments(Tree.randomId(), Collections.singletonList((Expression)message.withPrefix("")), Formatting.EMPTY), null, Formatting.EMPTY);
        }
        J.MethodInvocation replacement = new J.MethodInvocation(Tree.randomId(), (Expression)assertSelect, null, J.Ident.build((UUID)Tree.randomId(), (String)"isTrue", (JavaType)JavaType.Primitive.Boolean, (Formatting)Formatting.EMPTY), new J.MethodInvocation.Arguments(Tree.randomId(), Collections.emptyList(), Formatting.EMPTY), null, Formatting.format((String)"\n"));
        this.maybeAddStaticImport(ASSERTJ_QUALIFIED_ASSERTIONS_CLASS, ASSERTJ_ASSERT_THAT_METHOD);
        this.andThen((RefactorVisitor)new AutoFormat(new J[]{replacement}));
        return replacement;
    }

    public void maybeAddStaticImport(String fullyQualifiedName, String method) {
        AddImport op = new AddImport();
        op.setType(fullyQualifiedName);
        op.setStaticMethod(method);
        this.andThen((RefactorVisitor)op);
    }

    static {
        JavaType.Method.Signature booleanAssertThatMethod = new JavaType.Method.Signature((JavaType)JavaType.Class.build((String)ASSERTJ_QUALIFIED_BOOLEAN_ASSERT_CLASS), Collections.singletonList(JavaType.Primitive.Boolean));
        assertThatMethodDeclaration = JavaType.Method.build((JavaType.FullyQualified)JavaType.Class.build((String)ASSERTJ_QUALIFIED_ASSERTIONS_CLASS), (String)ASSERTJ_ASSERT_THAT_METHOD, (JavaType.Method.Signature)booleanAssertThatMethod, (JavaType.Method.Signature)booleanAssertThatMethod, Collections.singletonList("arg1"), Stream.of(Flag.Public, Flag.Static).collect(Collectors.toSet()));
    }
}

