/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@AutoConfigure
public class AssertToAssertions
extends JavaIsoRefactorVisitor {
    public J.ClassDecl visitClassDecl(J.ClassDecl classDecl) {
        ChangeType ct = new ChangeType();
        ct.setType("org.junit.Assert");
        ct.setTargetType("org.junit.jupiter.api.Assertions");
        this.andThen((RefactorVisitor)ct);
        return super.visitClassDecl(classDecl);
    }

    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method) {
        J.MethodInvocation m = super.visitMethodInvocation(method);
        if (!this.isJunitAssertMethod(m)) {
            return m;
        }
        List args = m.getArgs().getArgs();
        Expression firstArg = (Expression)args.get(0);
        if (args.size() == 2 && this.isString(firstArg.getType()) && this.isString(((Expression)args.get(1)).getType())) {
            return m;
        }
        if (this.isString(firstArg.getType())) {
            Formatting firstFormatting = firstArg.getFormatting();
            Formatting lastFormatting = ((Expression)args.get(args.size() - 1)).getFormatting();
            List newArgs = Stream.concat(args.stream().skip(1L), Stream.of(firstArg)).collect(Collectors.toList());
            int lastIndex = newArgs.size() - 1;
            newArgs.set(0, (Expression)((Expression)newArgs.get(0)).withFormatting(firstFormatting));
            newArgs.set(lastIndex, (Expression)((Expression)newArgs.get(lastIndex)).withFormatting(lastFormatting));
            m = m.withArgs(m.getArgs().withArgs(newArgs));
        }
        return m;
    }

    private boolean isJunitAssertMethod(J.MethodInvocation method) {
        if (!(method.getSelect() instanceof J.Ident)) {
            return false;
        }
        J.Ident receiver = (J.Ident)method.getSelect();
        if (!(receiver.getType() instanceof JavaType.FullyQualified)) {
            return false;
        }
        JavaType.FullyQualified receiverType = (JavaType.FullyQualified)receiver.getType();
        return receiverType.getFullyQualifiedName().equals("org.junit.Assert");
    }

    private boolean isString(JavaType type) {
        return type instanceof JavaType.Primitive && ((JavaType.Primitive)type).name().equals("String");
    }
}

