/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import org.openrewrite.AutoConfigure;
import org.openrewrite.CompositeRefactorVisitor;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.maven.AddDependency;
import org.openrewrite.maven.MavenRefactorVisitor;
import org.openrewrite.maven.tree.Maven;

@AutoConfigure
public class MaybeAddJUnit5Dependencies
extends CompositeRefactorVisitor {
    private String version = "5.x";
    private boolean junitReferencesExist = false;

    public MaybeAddJUnit5Dependencies() {
        this.addVisitor((RefactorVisitor)new FindJUnit());
        this.addVisitor((RefactorVisitor)new AddDependencies());
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Validated validate() {
        return Validated.required((String)"version", (Object)this.version);
    }

    private class AddDependencies
    extends MavenRefactorVisitor {
        private AddDependencies() {
        }

        public Maven visitMaven(Maven maven) {
            if (MaybeAddJUnit5Dependencies.this.junitReferencesExist) {
                AddDependency addJunitApi = new AddDependency();
                addJunitApi.setGroupId("org.junit.jupiter");
                addJunitApi.setArtifactId("junit-jupiter-api");
                addJunitApi.setVersion(MaybeAddJUnit5Dependencies.this.version);
                addJunitApi.setScope("test");
                this.andThen((RefactorVisitor)addJunitApi);
                AddDependency addJunitJupiterEngine = new AddDependency();
                addJunitJupiterEngine.setGroupId("org.junit.jupiter");
                addJunitJupiterEngine.setArtifactId("junit-jupiter-engine");
                addJunitJupiterEngine.setVersion(MaybeAddJUnit5Dependencies.this.version);
                addJunitJupiterEngine.setScope("test");
                this.andThen((RefactorVisitor)addJunitJupiterEngine);
            }
            return super.visitMaven(maven);
        }
    }

    private class FindJUnit
    extends JavaRefactorVisitor {
        private FindJUnit() {
        }

        public J visitCompilationUnit(J.CompilationUnit cu) {
            MaybeAddJUnit5Dependencies.this.junitReferencesExist = cu.hasType("junit.framework.Test") || cu.hasType("org.junit.jupiter.api.Test");
            return cu;
        }
    }
}

