/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.AutoFormat;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

@AutoConfigure
public class CategoryToTag
extends JavaIsoRefactorVisitor {
    private static final String categoryAnnotation = "org.junit.experimental.categories.Category";
    private static final JavaType.Class tagType = JavaType.Class.build((String)"org.junit.jupiter.api.Tag");

    public J.ClassDecl visitClassDecl(J.ClassDecl classDecl) {
        J.ClassDecl cd = super.visitClassDecl(classDecl);
        List categoryAnnotations = cd.findAnnotationsOnClass("@org.junit.experimental.categories.Category");
        if (!categoryAnnotations.isEmpty()) {
            this.andThen((RefactorVisitor)new Scoped((J)cd));
        }
        return cd;
    }

    public J.MethodDecl visitMethod(J.MethodDecl method) {
        J.MethodDecl m = super.visitMethod(method);
        List categoryAnnotations = m.findAnnotations("@org.junit.experimental.categories.Category");
        if (!categoryAnnotations.isEmpty()) {
            this.andThen((RefactorVisitor)new Scoped((J)m));
        }
        return m;
    }

    public static class Scoped
    extends JavaIsoRefactorVisitor {
        final J scope;

        public Scoped(J scope) {
            this.scope = scope;
        }

        public J.ClassDecl visitClassDecl(J.ClassDecl classDecl) {
            J.ClassDecl c = super.visitClassDecl(classDecl);
            if (this.scope.isScope((Tree)classDecl)) {
                AtomicInteger index = new AtomicInteger(0);
                c = c.withAnnotations(c.getAnnotations().stream().flatMap(this::categoryAnnotationToTagAnnotations).map(annotation -> {
                    this.andThen((RefactorVisitor)new AutoFormat(new J[]{annotation}));
                    if (index.getAndIncrement() != 0) {
                        return (J.Annotation)annotation.withPrefix("\n");
                    }
                    return annotation;
                }).collect(Collectors.toList()));
                this.maybeRemoveImport(CategoryToTag.categoryAnnotation);
                this.maybeAddImport((JavaType.FullyQualified)tagType);
            }
            return c;
        }

        public J.MethodDecl visitMethod(J.MethodDecl m) {
            if (this.scope.isScope((Tree)m)) {
                AtomicInteger index = new AtomicInteger(0);
                m = m.withAnnotations(m.getAnnotations().stream().flatMap(this::categoryAnnotationToTagAnnotations).map(annotation -> {
                    this.andThen((RefactorVisitor)new AutoFormat(new J[]{annotation}));
                    if (index.getAndIncrement() != 0) {
                        return (J.Annotation)annotation.withPrefix("\n");
                    }
                    return annotation;
                }).collect(Collectors.toList()));
                this.maybeRemoveImport(CategoryToTag.categoryAnnotation);
                this.maybeAddImport((JavaType.FullyQualified)tagType);
            }
            return m;
        }

        private Stream<J.Annotation> categoryAnnotationToTagAnnotations(J.Annotation maybeCategory) {
            if (TypeUtils.isOfClassType((JavaType)maybeCategory.getAnnotationType().getType(), (String)CategoryToTag.categoryAnnotation)) {
                Expression annotationArgument = (Expression)maybeCategory.getArgs().getArgs().iterator().next();
                Stream<J.FieldAccess> categories = annotationArgument instanceof J.NewArray ? ((J.NewArray)annotationArgument).getInitializer().getElements().stream().map(J.FieldAccess.class::cast) : Stream.of((J.FieldAccess)annotationArgument);
                return categories.map(category -> {
                    String targetName = ((J.Ident)category.getTarget()).getSimpleName();
                    J.Literal tagValue = new J.Literal(Tree.randomId(), (Object)targetName, "\"" + targetName + "\"", JavaType.Primitive.String, Formatting.EMPTY);
                    J.Annotation tagAnnotation = J.Annotation.buildAnnotation((Formatting)maybeCategory.getFormatting(), (JavaType.Class)tagType, Collections.singletonList(tagValue));
                    this.maybeRemoveImport(TypeUtils.asFullyQualified((JavaType)category.getTarget().getType()));
                    return tagAnnotation;
                });
            }
            return Stream.of(maybeCategory);
        }
    }
}

