/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.time.Duration;
import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class UseExplicitContains
extends Recipe {
    public String getDisplayName() {
        return "Use explicit contains in Assertj";
    }

    public String getDescription() {
        return "Convert AssertJ `assertThat(collection.contains(element)).isTrue()` with assertThat(collection).contains(element) and `assertThat(collection.contains(element)).isFalse()` with assertThat(collection).doesNotContain(element).";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.assertj.core.api.Assertions");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new UseExplicitContainsVisitor();
    }

    public static class UseExplicitContainsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private Supplier<JavaParser> assertionsParser;
        private static final MethodMatcher ASSERT_THAT = new MethodMatcher("org.assertj.core.api.Assertions assertThat(..)");
        private static final MethodMatcher IS_TRUE = new MethodMatcher("org.assertj.core.api.AbstractBooleanAssert isTrue()");
        private static final MethodMatcher IS_FALSE = new MethodMatcher("org.assertj.core.api.AbstractBooleanAssert isFalse()");
        private static final MethodMatcher CONTAINS = new MethodMatcher("java.util.Collection contains(..)", true);

        private Supplier<JavaParser> assertionsParser(ExecutionContext ctx) {
            if (this.assertionsParser == null) {
                this.assertionsParser = () -> JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24.2"}).build();
            }
            return this.assertionsParser;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation m, ExecutionContext ctx) {
            J.MethodInvocation method = super.visitMethodInvocation(m, (Object)ctx);
            boolean isTrue = IS_TRUE.matches(method);
            if (!isTrue && !IS_FALSE.matches(method)) {
                return method;
            }
            if (!(method.getSelect() instanceof J.MethodInvocation)) {
                return method;
            }
            if (!ASSERT_THAT.matches((J.MethodInvocation)method.getSelect())) {
                return method;
            }
            J.MethodInvocation assertThat = (J.MethodInvocation)method.getSelect();
            if (!(assertThat.getArguments().get(0) instanceof J.MethodInvocation)) {
                return method;
            }
            J.MethodInvocation contains = (J.MethodInvocation)assertThat.getArguments().get(0);
            if (!CONTAINS.matches(contains)) {
                return method;
            }
            Expression list = contains.getSelect();
            Expression element = (Expression)contains.getArguments().get(0);
            String template = isTrue ? "assertThat(#{any()}).contains(#{any()});" : "assertThat(#{any()}).doesNotContain(#{any()});";
            JavaTemplate builtTemplate = JavaTemplate.builder(() -> ((UseExplicitContainsVisitor)this).getCursor(), (String)template).javaParser(this.assertionsParser(ctx)).build();
            return (J.MethodInvocation)method.withTemplate((SourceTemplate)builtTemplate, method.getCoordinates().replace(), new Object[]{list, element});
        }
    }
}

