/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.ChangeMethodAccessLevelVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class TestsShouldNotBePublic
extends Recipe {
    @Option(displayName="Remove protected modifiers", description="Also remove protected modifiers from test methods", example="true", required=false)
    @Nullable
    private Boolean removeProtectedModifiers;

    public String getDisplayName() {
        return "Remove `public` visibility of JUnit 5 tests";
    }

    public String getDescription() {
        return "Remove `public` and optionally `protected` modifiers from methods with `@Test`, `@ParameterizedTest`, `@RepeatedTest`, `@TestFactory`, `@BeforeEach`, `@AfterEach`, `@BeforeAll`, or `@AfterAll`. They no longer have to be public visibility to be usable by JUnit 5.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-5786");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TestsNotPublicVisitor(Boolean.TRUE.equals(this.removeProtectedModifiers));
    }

    @ConstructorProperties(value={"removeProtectedModifiers"})
    public TestsShouldNotBePublic(@Nullable Boolean removeProtectedModifiers) {
        this.removeProtectedModifiers = removeProtectedModifiers;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestsShouldNotBePublic)) {
            return false;
        }
        TestsShouldNotBePublic other = (TestsShouldNotBePublic)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$removeProtectedModifiers = this.removeProtectedModifiers;
        Boolean other$removeProtectedModifiers = other.removeProtectedModifiers;
        return !(this$removeProtectedModifiers == null ? other$removeProtectedModifiers != null : !((Object)this$removeProtectedModifiers).equals(other$removeProtectedModifiers));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof TestsShouldNotBePublic;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $removeProtectedModifiers = this.removeProtectedModifiers;
        result = result * 59 + ($removeProtectedModifiers == null ? 43 : ((Object)$removeProtectedModifiers).hashCode());
        return result;
    }

    private static final class TestsNotPublicVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final Boolean orProtected;

        private TestsNotPublicVisitor(Boolean orProtected) {
            this.orProtected = orProtected;
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
            J.ClassDeclaration c = super.visitClassDeclaration(classDecl, (Object)executionContext);
            if (c.getModifiers().stream().anyMatch(mod -> mod.getType() == J.Modifier.Type.Public) && c.getModifiers().stream().noneMatch(mod -> mod.getType() == J.Modifier.Type.Abstract)) {
                boolean hasTestMethods = c.getBody().getStatements().stream().filter(statement -> statement instanceof J.MethodDeclaration).map(J.MethodDeclaration.class::cast).anyMatch(this::hasJUnit5MethodAnnotation);
                boolean hasPublicNonTestMethods = c.getBody().getStatements().stream().filter(statement -> statement instanceof J.MethodDeclaration).map(J.MethodDeclaration.class::cast).filter(m -> m.getModifiers().stream().anyMatch(mod -> mod.getType() == J.Modifier.Type.Public)).anyMatch(method -> !this.hasJUnit5MethodAnnotation((J.MethodDeclaration)method));
                boolean hasPublicVariableDeclarations = c.getBody().getStatements().stream().filter(statement -> statement instanceof J.VariableDeclarations).map(J.VariableDeclarations.class::cast).anyMatch(m -> m.getModifiers().stream().anyMatch(mod -> mod.getType() == J.Modifier.Type.Public));
                if (hasTestMethods && !hasPublicNonTestMethods && !hasPublicVariableDeclarations) {
                    ArrayList modifierComments = new ArrayList();
                    List modifiers = ListUtils.map((List)c.getModifiers(), mod -> {
                        if (mod.getType() == J.Modifier.Type.Public) {
                            modifierComments.addAll(mod.getComments());
                            return null;
                        }
                        if (!modifierComments.isEmpty()) {
                            J.Modifier nextModifier = (J.Modifier)mod.withComments(ListUtils.concatAll(new ArrayList(modifierComments), (List)mod.getComments()));
                            modifierComments.clear();
                            return nextModifier;
                        }
                        return mod;
                    });
                    if (!modifierComments.isEmpty()) {
                        c = (J.ClassDeclaration)c.withComments(ListUtils.concatAll((List)c.getComments(), modifierComments));
                    }
                    c = (J.ClassDeclaration)this.maybeAutoFormat((J)c, (J)c.withModifiers(modifiers), (J)c.getName(), executionContext, this.getCursor().getParentTreeCursor());
                }
            }
            return c;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
            J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)executionContext);
            if (method.getMethodType() == null || method.getMethodType().getDeclaringType().hasFlags(new Flag[]{Flag.Abstract, Flag.Public})) {
                return m;
            }
            if (m.getModifiers().stream().anyMatch(mod -> mod.getType() == J.Modifier.Type.Public || this.orProtected != false && mod.getType() == J.Modifier.Type.Protected) && Boolean.FALSE.equals(TypeUtils.isOverride((JavaType.Method)method.getMethodType())) && this.hasJUnit5MethodAnnotation(m)) {
                this.doAfterVisit((TreeVisitor)new ChangeMethodAccessLevelVisitor(new MethodMatcher(method), null));
            }
            return m;
        }

        private boolean hasJUnit5MethodAnnotation(J.MethodDeclaration method) {
            for (J.Annotation a : method.getLeadingAnnotations()) {
                if (!TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.Test") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.RepeatedTest") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.params.ParameterizedTest") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.TestFactory") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.AfterEach") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.BeforeEach") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.AfterAll") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.BeforeAll")) continue;
                return true;
            }
            return false;
        }
    }
}

