/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.time.Duration;
import java.util.Collections;
import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.maven.UpgradeDependencyVersion;
import org.openrewrite.template.SourceTemplate;

public class UseWiremockExtension
extends Recipe {
    public String getDisplayName() {
        return "Use wiremock extension";
    }

    public String getDescription() {
        return "As of 2.31.0, wiremock [supports JUnit 5](http://wiremock.org/docs/junit-jupiter/) via an extension.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("com.github.tomakehurst.wiremock.junit.WireMockRule");
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        final MethodMatcher newWiremockRule = new MethodMatcher("com.github.tomakehurst.wiremock.junit.WireMockRule <constructor>(..)");
        return new JavaVisitor<ExecutionContext>(){

            public J visitJavaSourceFile(JavaSourceFile cu, ExecutionContext context) {
                UseWiremockExtension.this.doNext((Recipe)new ChangeType("com.github.tomakehurst.wiremock.junit.WireMockRule", "com.github.tomakehurst.wiremock.junit5.WireMockExtension", Boolean.valueOf(true)));
                return super.visitJavaSourceFile(cu, (Object)context);
            }

            public J visitNewClass(J.NewClass newClass, ExecutionContext executionContext) {
                J.NewClass n = (J.NewClass)super.visitNewClass(newClass, (Object)executionContext);
                if (newWiremockRule.matches(n)) {
                    this.maybeAddImport("com.github.tomakehurst.wiremock.junit5.WireMockExtension");
                    this.doAfterVisit((Recipe)new ChangeType("org.junit.Rule", "org.junit.jupiter.api.extension.RegisterExtension", Boolean.valueOf(true)));
                    UseWiremockExtension.this.doNext((Recipe)new UpgradeDependencyVersion("com.github.tomakehurst", "wiremock-jre8", "2.x", null, Boolean.valueOf(true), Collections.emptyList()));
                    Expression arg = (Expression)n.getArguments().get(0);
                    Supplier<JavaParser> wiremockParser = () -> JavaParser.fromJavaVersion().dependsOn(new String[]{"package com.github.tomakehurst.wiremock.junit5;import com.github.tomakehurst.wiremock.core.Options;public class WireMockExtension {  public native static Builder newInstance();  public static class Builder {    public native Builder options(Options options);    public native Builder failOnUnmatchedRequests(boolean failOnUnmatched);    public native WireMockExtension build();  }}", "package com.github.tomakehurst.wiremock.core;public class WireMockConfiguration implements Options {  public static native WireMockConfiguration options();  public native WireMockConfiguration port(int portNumber);  public native WireMockConfiguration dynamicPort();  public native WireMockConfiguration httpsPort(Integer httpsPort);  public native WireMockConfiguration dynamicHttpsPort();}", "package com.github.tomakehurst.wiremock.core;public interface Options {}"}).build();
                    if (arg instanceof J.Empty) {
                        String newWiremockExtension = "WireMockExtension.newInstance().build()";
                        return n.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)newWiremockExtension).imports(new String[]{"com.github.tomakehurst.wiremock.junit5.WireMockExtension"}).javaParser(wiremockParser).build(), n.getCoordinates().replace(), new Object[0]);
                    }
                    JavaType.ShallowClass optsType = JavaType.ShallowClass.build((String)"com.github.tomakehurst.wiremock.core.Options");
                    if (TypeUtils.isAssignableTo((JavaType)optsType, (JavaType)arg.getType())) {
                        String newWiremockExtension = "WireMockExtension.newInstance().options(#{any(com.github.tomakehurst.wiremock.core.Options)})";
                        if (n.getArguments().size() > 1) {
                            newWiremockExtension = newWiremockExtension + ".failOnUnmatchedRequests(#{any(boolean)})";
                            return n.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)(newWiremockExtension + ".build()")).imports(new String[]{"com.github.tomakehurst.wiremock.junit5.WireMockExtension"}).javaParser(wiremockParser).build(), n.getCoordinates().replace(), new Object[]{arg, n.getArguments().get(1)});
                        }
                        return n.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)(newWiremockExtension + ".build()")).imports(new String[]{"com.github.tomakehurst.wiremock.junit5.WireMockExtension"}).javaParser(wiremockParser).build(), n.getCoordinates().replace(), new Object[]{arg});
                    }
                    this.maybeAddImport("com.github.tomakehurst.wiremock.core.WireMockConfiguration");
                    String newWiremockExtension = "WireMockExtension.newInstance().options(WireMockConfiguration.options().port(#{any(int)})";
                    if (n.getArguments().size() > 1) {
                        newWiremockExtension = newWiremockExtension + ".httpsPort(#{any(java.lang.Integer)})";
                        return n.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)(newWiremockExtension + ").build()")).imports(new String[]{"com.github.tomakehurst.wiremock.core.WireMockConfiguration"}).imports(new String[]{"com.github.tomakehurst.wiremock.junit5.WireMockExtension"}).javaParser(wiremockParser).build(), n.getCoordinates().replace(), new Object[]{arg, n.getArguments().get(1)});
                    }
                    return n.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)(newWiremockExtension + ").build()")).imports(new String[]{"com.github.tomakehurst.wiremock.core.WireMockConfiguration"}).imports(new String[]{"com.github.tomakehurst.wiremock.junit5.WireMockExtension"}).javaParser(wiremockParser).build(), n.getCoordinates().replace(), new Object[]{arg});
                }
                return n;
            }
        };
    }
}

