/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class JUnitAssertNotEqualsToAssertThat
extends Recipe {
    public String getDisplayName() {
        return "JUnit `assertNotEquals` to AssertJ";
    }

    public String getDescription() {
        return "Convert JUnit-style `assertNotEquals()` to AssertJ's `assertThat().isNotEqualTo()`.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.junit.jupiter.api.Assertions");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AssertNotEqualsToAssertThatVisitor();
    }

    public static class AssertNotEqualsToAssertThatVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private Supplier<JavaParser> assertionsParser;
        private static final MethodMatcher JUNIT_ASSERT_EQUALS = new MethodMatcher("org.junit.jupiter.api.Assertions assertNotEquals(..)");

        private Supplier<JavaParser> assertionsParser(ExecutionContext ctx) {
            if (this.assertionsParser == null) {
                this.assertionsParser = () -> JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24.2"}).build();
            }
            return this.assertionsParser;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (!JUNIT_ASSERT_EQUALS.matches(method)) {
                return method;
            }
            List args = method.getArguments();
            Expression expected = (Expression)args.get(0);
            Expression actual = (Expression)args.get(1);
            if (args.size() == 2) {
                method = (J.MethodInvocation)method.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((AssertNotEqualsToAssertThatVisitor)this).getCursor(), (String)"assertThat(#{any()}).isNotEqualTo(#{any()});").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(this.assertionsParser(ctx)).build(), method.getCoordinates().replace(), new Object[]{actual, expected});
            } else if (args.size() == 3 && !AssertNotEqualsToAssertThatVisitor.isFloatingPointType((Expression)args.get(2))) {
                Expression message = (Expression)args.get(2);
                JavaTemplate.Builder template = TypeUtils.isString((JavaType)message.getType()) ? JavaTemplate.builder(() -> ((AssertNotEqualsToAssertThatVisitor)this).getCursor(), (String)"assertThat(#{any()}).as(#{any(String)}).isNotEqualTo(#{any()});") : JavaTemplate.builder(() -> ((AssertNotEqualsToAssertThatVisitor)this).getCursor(), (String)"assertThat(#{any()}).as(#{any(java.util.function.Supplier)}).isNotEqualTo(#{any()});");
                method = (J.MethodInvocation)method.withTemplate((SourceTemplate)template.staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(this.assertionsParser(ctx)).build(), method.getCoordinates().replace(), new Object[]{actual, message, expected});
            } else if (args.size() == 3) {
                method = (J.MethodInvocation)method.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((AssertNotEqualsToAssertThatVisitor)this).getCursor(), (String)"assertThat(#{any()}).isNotCloseTo(#{any()}, within(#{any()}));").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat", "org.assertj.core.api.Assertions.within"}).javaParser(this.assertionsParser(ctx)).build(), method.getCoordinates().replace(), new Object[]{actual, expected, args.get(2)});
                this.maybeAddImport("org.assertj.core.api.Assertions", "within");
            } else {
                Expression message = (Expression)args.get(3);
                JavaTemplate.Builder template = TypeUtils.isString((JavaType)message.getType()) ? JavaTemplate.builder(() -> ((AssertNotEqualsToAssertThatVisitor)this).getCursor(), (String)"assertThat(#{any()}).as(#{any(String)}).isNotCloseTo(#{any()}, within(#{any()}));") : JavaTemplate.builder(() -> ((AssertNotEqualsToAssertThatVisitor)this).getCursor(), (String)"assertThat(#{any()}).as(#{any(java.util.function.Supplier)}).isNotCloseTo(#{any()}, within(#{any()}));");
                method = (J.MethodInvocation)method.withTemplate((SourceTemplate)template.staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat", "org.assertj.core.api.Assertions.within"}).javaParser(this.assertionsParser(ctx)).build(), method.getCoordinates().replace(), new Object[]{actual, message, expected, args.get(2)});
                this.maybeAddImport("org.assertj.core.api.Assertions", "within");
            }
            this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat");
            this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
            return method;
        }

        private static boolean isFloatingPointType(Expression expression) {
            JavaType.FullyQualified fullyQualified = TypeUtils.asFullyQualified((JavaType)expression.getType());
            if (fullyQualified != null) {
                String typeName = fullyQualified.getFullyQualifiedName();
                return "java.lang.Double".equals(typeName) || "java.lang.Float".equals(typeName);
            }
            JavaType.Primitive parameterType = TypeUtils.asPrimitive((JavaType)expression.getType());
            return parameterType == JavaType.Primitive.Double || parameterType == JavaType.Primitive.Float;
        }
    }
}

