/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cucumber;

import java.time.Duration;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.testing.cucumber.CucumberJava8ClassVisitor;
import org.openrewrite.java.testing.cucumber.StepDefinitionArguments;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public final class CucumberJava8StepDefinitionToCucumberJava
extends Recipe {
    private static final String IO_CUCUMBER_JAVA8_STEP_DEFINITION = "io.cucumber.java8.* *(String, ..)";
    private static final String IO_CUCUMBER_JAVA8_STEP_DEFINITION_BODY = "io.cucumber.java8.StepDefinitionBody";
    private static final MethodMatcher STEP_DEFINITION_METHOD_MATCHER = new MethodMatcher("io.cucumber.java8.* *(String, ..)");

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(IO_CUCUMBER_JAVA8_STEP_DEFINITION, true);
    }

    public String getDisplayName() {
        return "Replace Cucumber-Java8 step definitions with Cucumber-Java";
    }

    public String getDescription() {
        return "Replace StepDefinitionBody methods with StepDefinitionAnnotations on new methods with the same body.";
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(10L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new CucumberStepDefinitionBodyVisitor();
    }

    @NonNull
    public String toString() {
        return "CucumberJava8StepDefinitionToCucumberJava()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CucumberJava8StepDefinitionToCucumberJava)) {
            return false;
        }
        CucumberJava8StepDefinitionToCucumberJava other = (CucumberJava8StepDefinitionToCucumberJava)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CucumberJava8StepDefinitionToCucumberJava;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    static final class CucumberStepDefinitionBodyVisitor
    extends JavaVisitor<ExecutionContext> {
        CucumberStepDefinitionBodyVisitor() {
        }

        public J visitMethodInvocation(J.MethodInvocation methodInvocation, ExecutionContext p) {
            J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(methodInvocation, (Object)p);
            if (!STEP_DEFINITION_METHOD_MATCHER.matches(m)) {
                return m;
            }
            List arguments = m.getArguments();
            if (arguments.size() < 2) {
                return m;
            }
            Expression stringExpression = (Expression)arguments.get(0);
            if (!(stringExpression instanceof J.Literal)) {
                return (J)SearchResult.found((Tree)m, (String)"TODO Migrate manually");
            }
            J.Literal literal = (J.Literal)stringExpression;
            Expression possibleStepDefinitionBody = (Expression)arguments.get(1);
            if (!(possibleStepDefinitionBody instanceof J.Lambda) || !TypeUtils.isAssignableTo((String)CucumberJava8StepDefinitionToCucumberJava.IO_CUCUMBER_JAVA8_STEP_DEFINITION_BODY, (JavaType)possibleStepDefinitionBody.getType())) {
                return (J)SearchResult.found((Tree)m, (String)"TODO Migrate manually");
            }
            J.Lambda lambda = (J.Lambda)possibleStepDefinitionBody;
            StepDefinitionArguments stepArguments = new StepDefinitionArguments(m.getSimpleName(), literal, lambda);
            J.ClassDeclaration parentClass = (J.ClassDeclaration)this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance).getValue();
            if (m.getMethodType() == null) {
                return m;
            }
            String replacementImport = String.format("%s.%s", m.getMethodType().getDeclaringType().getFullyQualifiedName().replace("java8", "java").toLowerCase(), m.getSimpleName());
            this.doAfterVisit((TreeVisitor)new CucumberJava8ClassVisitor(parentClass.getType(), replacementImport, stepArguments.template(), stepArguments.parameters()));
            return null;
        }
    }
}

