/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.time.Duration;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.PartProvider;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class AnyStringToNullable
extends Recipe {
    private static final MethodMatcher ANY_STRING = new MethodMatcher("org.mockito.Mockito anyString()");
    private static final String MOCKITO_CLASS_PATH = "mockito-core-3.12.4";
    private static J.MethodInvocation nullableStringMethodTemplate = null;

    public String getDisplayName() {
        return "Replace Mockito 1.x `anyString()` with `nullable(String.class)`";
    }

    public String getDescription() {
        return "Since Mockito 2.10 `anyString()` no longer matches null values. Use `nullable(Class)` instead.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(ANY_STRING);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)executionContext);
                if (ANY_STRING.matches(mi)) {
                    this.maybeAddImport("org.mockito.ArgumentMatchers", "nullable", false);
                    this.maybeRemoveImport("org.mockito.Mockito.anyString");
                    return AnyStringToNullable.getNullableMethodTemplate().withPrefix(mi.getPrefix());
                }
                return mi;
            }
        };
    }

    private static J.MethodInvocation getNullableMethodTemplate() {
        if (nullableStringMethodTemplate == null) {
            nullableStringMethodTemplate = (J.MethodInvocation)PartProvider.buildPart((String)"import static org.mockito.ArgumentMatchers.nullable;\npublic class A {\n    void method() {\n        Object x = nullable(String.class);\n    }\n}", J.MethodInvocation.class, (String[])new String[]{MOCKITO_CLASS_PATH});
        }
        return nullableStringMethodTemplate;
    }
}

