/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public final class AddMissingNested
extends Recipe {
    private static final String NESTED = "org.junit.jupiter.api.Nested";
    private static final List<String> TEST_ANNOTATIONS = Arrays.asList("org.junit.jupiter.api.Test", "org.junit.jupiter.api.TestTemplate", "org.junit.jupiter.api.RepeatedTest", "org.junit.jupiter.params.ParameterizedTest", "org.junit.jupiter.api.TestFactory");

    public String getDisplayName() {
        return "JUnit 5 inner test classes should be annotated with `@Nested`";
    }

    public String getDescription() {
        return "Adds `@Nested` to inner classes that contain JUnit 5 tests.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitJavaSourceFile(JavaSourceFile cu, ExecutionContext ctx) {
                TEST_ANNOTATIONS.forEach(ann -> this.doAfterVisit((TreeVisitor)new UsesType(ann, Boolean.valueOf(false))));
                return cu;
            }
        };
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-5790");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                cd = cd.withBody((J.Block)new AddNestedAnnotationVisitor().visitNonNull((Tree)cd.getBody(), ctx, this.getCursor()));
                this.maybeAddImport(AddMissingNested.NESTED);
                return cd;
            }
        };
    }

    @NonNull
    public String toString() {
        return "AddMissingNested()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddMissingNested)) {
            return false;
        }
        AddMissingNested other = (AddMissingNested)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddMissingNested;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public static class AddNestedAnnotationVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            boolean alreadyNested = classDecl.getLeadingAnnotations().stream().anyMatch(a -> TypeUtils.isOfClassType((JavaType)a.getType(), (String)AddMissingNested.NESTED));
            if (!alreadyNested && AddNestedAnnotationVisitor.hasTestMethods(cd)) {
                cd = (J.ClassDeclaration)cd.withTemplate((SourceTemplate)this.getNestedJavaTemplate(ctx), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                cd.getModifiers().removeIf(modifier -> modifier.getType().equals((Object)J.Modifier.Type.Static));
            }
            return cd;
        }

        @NonNull
        private JavaTemplate getNestedJavaTemplate(ExecutionContext ctx) {
            return JavaTemplate.builder(() -> ((AddNestedAnnotationVisitor)this).getCursor(), (String)"@Nested").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5.9.2"})).imports(new String[]{AddMissingNested.NESTED}).build();
        }

        private static boolean hasTestMethods(J.ClassDeclaration cd) {
            return TEST_ANNOTATIONS.stream().anyMatch(ann -> !FindAnnotations.find((J)cd, (String)("@" + ann)).isEmpty());
        }
    }
}

