/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.UseStaticImport;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.testing.junit5.AssertToAssertions;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.template.SourceTemplate;

public class MigrateJUnitTestCase
extends Recipe {
    private static final AnnotationMatcher JUNIT_TEST_ANNOTATION_MATCHER = new AnnotationMatcher("@org.junit.Test");

    private static boolean isSupertypeTestCase(@Nullable JavaType.FullyQualified fullyQualified) {
        if (fullyQualified == null || fullyQualified.getSupertype() == null || "java.lang.Object".equals(fullyQualified.getFullyQualifiedName())) {
            return false;
        }
        JavaType.FullyQualified fqType = TypeUtils.asFullyQualified((JavaType)fullyQualified);
        if (fqType != null && "junit.framework.TestCase".equals(fqType.getFullyQualifiedName())) {
            return true;
        }
        return MigrateJUnitTestCase.isSupertypeTestCase(fullyQualified.getSupertype());
    }

    public String getDisplayName() {
        return "Migrate JUnit 4 `TestCase` to JUnit Jupiter";
    }

    public String getDescription() {
        return "Convert JUnit 4 `TestCase` to JUnit Jupiter.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                for (J.ClassDeclaration clazz : cu.getClasses()) {
                    if (!TypeUtils.isAssignableTo((JavaType)JavaType.ShallowClass.build((String)"junit.framework.TestCase"), (JavaType)clazz.getType())) continue;
                    return (J.CompilationUnit)SearchResult.found((Tree)cu);
                }
                this.doAfterVisit((TreeVisitor)new UsesType("junit.framework.TestCase", Boolean.valueOf(false)));
                this.doAfterVisit((TreeVisitor)new UsesType("junit.framework.Assert", Boolean.valueOf(false)));
                return cu;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                J.CompilationUnit c = super.visitCompilationUnit(cu, (Object)ctx);
                this.doAfterVisit((TreeVisitor)new TestCaseVisitor());
                this.doAfterVisit((Recipe)new ChangeType("junit.framework.TestCase", "org.junit.Assert", Boolean.valueOf(true)));
                this.doAfterVisit((Recipe)new ChangeType("junit.framework.Assert", "org.junit.Assert", Boolean.valueOf(true)));
                this.doAfterVisit((TreeVisitor)new AssertToAssertions.AssertToAssertionsVisitor());
                this.doAfterVisit((Recipe)new UseStaticImport("org.junit.jupiter.api.Assertions assert*(..)"));
                this.doAfterVisit((Recipe)new UseStaticImport("org.junit.jupiter.api.Assertions fail*(..)"));
                return c;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (mi.getSelect() != null && TypeUtils.isOfClassType((JavaType)mi.getSelect().getType(), (String)"junit.framework.TestCase") || mi.getMethodType() != null && TypeUtils.isOfClassType((JavaType)mi.getMethodType().getDeclaringType(), (String)"junit.framework.TestCase")) {
                    String name = mi.getSimpleName();
                    if ("setUp".equals(name) || "tearDown".equals(name)) {
                        return null;
                    }
                    if ("setName".equals(name)) {
                        mi = mi.withPrefix(mi.getPrefix().withComments(ListUtils.concat((List)mi.getPrefix().getComments(), (Object)new TextComment(false, "", "", Markers.EMPTY))));
                    }
                }
                return mi;
            }
        };
    }

    private static class TestCaseVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final AnnotationMatcher OVERRIDE_ANNOTATION_MATCHER = new AnnotationMatcher("@java.lang.Override");

        private TestCaseVisitor() {
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            JavaType.FullyQualified fullQualifiedExtension;
            if (!MigrateJUnitTestCase.isSupertypeTestCase(classDecl.getType())) {
                return classDecl;
            }
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            if (cd.getExtends() != null && cd.getExtends().getType() != null && (fullQualifiedExtension = TypeUtils.asFullyQualified((JavaType)cd.getExtends().getType())) != null && "junit.framework.TestCase".equals(fullQualifiedExtension.getFullyQualifiedName())) {
                cd = cd.withExtends(null);
            }
            this.maybeRemoveImport("junit.framework.TestCase");
            return cd;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
            if (md.getSimpleName().startsWith("test")) {
                if (md.getLeadingAnnotations().stream().noneMatch(arg_0 -> ((AnnotationMatcher)JUNIT_TEST_ANNOTATION_MATCHER).matches(arg_0))) {
                    return this.updateMethodDeclarationAnnotationAndModifier(md, "@Test", "org.junit.jupiter.api.Test", ctx);
                }
            }
            if ("setUp".equals(md.getSimpleName())) {
                return this.updateMethodDeclarationAnnotationAndModifier(md, "@BeforeEach", "org.junit.jupiter.api.BeforeEach", ctx);
            }
            if (!"tearDown".equals(md.getSimpleName())) return md;
            return this.updateMethodDeclarationAnnotationAndModifier(md, "@AfterEach", "org.junit.jupiter.api.AfterEach", ctx);
        }

        private J.MethodDeclaration updateMethodDeclarationAnnotationAndModifier(J.MethodDeclaration methodDeclaration, String annotation, String fullyQualifiedAnnotation, ExecutionContext ctx) {
            J.MethodDeclaration md = methodDeclaration;
            if (FindAnnotations.find((J)methodDeclaration.withBody(null), (String)("@" + fullyQualifiedAnnotation)).isEmpty()) {
                md = (J.MethodDeclaration)methodDeclaration.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((TestCaseVisitor)this).getCursor(), (String)annotation).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5.9.2"})).imports(new String[]{fullyQualifiedAnnotation}).build(), methodDeclaration.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                md = this.maybeAddPublicModifier(md);
                md = this.maybeRemoveOverrideAnnotation(md);
                this.maybeAddImport(fullyQualifiedAnnotation);
            }
            return md;
        }

        private J.MethodDeclaration maybeAddPublicModifier(J.MethodDeclaration md) {
            List modifiers = ListUtils.map((List)md.getModifiers(), modifier -> {
                if (modifier.getType() == J.Modifier.Type.Protected) {
                    return modifier.withType(J.Modifier.Type.Public);
                }
                return modifier;
            });
            return md.withModifiers(modifiers);
        }

        private J.MethodDeclaration maybeRemoveOverrideAnnotation(J.MethodDeclaration md) {
            return md.withLeadingAnnotations(ListUtils.map((List)md.getLeadingAnnotations(), annotation -> {
                if (OVERRIDE_ANNOTATION_MATCHER.matches(annotation)) {
                    return null;
                }
                return annotation;
            }));
        }
    }
}

