/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class UseExplicitSize
extends Recipe {
    private static final MethodMatcher ASSERT_THAT = new MethodMatcher("org.assertj.core.api.Assertions assertThat(..)");
    private static final MethodMatcher IS_EQUAL_TO = new MethodMatcher("org.assertj.core.api.* isEqualTo(..)");
    private static final MethodMatcher SIZE = new MethodMatcher("java.util.Collection size(..)", true);

    public String getDisplayName() {
        return "Use AssertJ `hasSize()` on collections";
    }

    public String getDescription() {
        return "Convert `assertThat(collection.size()).isEqualTo(Y)` to AssertJ's `assertThat(collection).hasSize()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.assertj.core.api.Assertions", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation m, ExecutionContext ctx) {
                J.MethodInvocation method = super.visitMethodInvocation(m, (Object)ctx);
                if (!IS_EQUAL_TO.matches(method)) {
                    return method;
                }
                if (!(method.getSelect() instanceof J.MethodInvocation)) {
                    return method;
                }
                if (!ASSERT_THAT.matches((J.MethodInvocation)method.getSelect())) {
                    return method;
                }
                J.MethodInvocation assertThat = (J.MethodInvocation)method.getSelect();
                if (!(assertThat.getArguments().get(0) instanceof J.MethodInvocation)) {
                    return method;
                }
                J.MethodInvocation size = (J.MethodInvocation)assertThat.getArguments().get(0);
                if (!SIZE.matches(size)) {
                    return method;
                }
                Expression list = size.getSelect();
                Expression expectedSize = (Expression)method.getArguments().get(0);
                return (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{any(java.util.List)}).hasSize(#{any()});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24"})).staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).build().apply(this.updateCursor((Tree)method), method.getCoordinates().replace(), new Object[]{list, expectedSize});
            }
        });
    }
}

