/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public class CleanupJUnitImports
extends Recipe {
    public String getDisplayName() {
        return "Cleanup JUnit imports";
    }

    public String getDescription() {
        return "Removes unused `org.junit` import symbols.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.junit.*", Boolean.valueOf(false)), new UsesType("junit.*", Boolean.valueOf(false))}), (TreeVisitor)new CleanupJUnitImportsVisitor());
    }

    public static class CleanupJUnitImportsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            for (J.Import im : cu.getImports()) {
                String packageName = im.getPackageName();
                if (!packageName.startsWith("junit") && (!packageName.startsWith("org.junit") || packageName.contains("jupiter"))) continue;
                this.maybeRemoveImport(im.getTypeName());
            }
            return cu;
        }
    }
}

