/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.dependencies.UpgradeDependencyVersion;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class UseWiremockExtension
extends Recipe {
    private static final MethodMatcher newWiremockRule = new MethodMatcher("com.github.tomakehurst.wiremock.junit.WireMockRule <constructor>(..)");

    public String getDisplayName() {
        return "Use wiremock extension";
    }

    public String getDescription() {
        return "As of 2.31.0, wiremock [supports JUnit 5](https://wiremock.org/docs/junit-jupiter/) via an extension.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("com.github.tomakehurst.wiremock.junit.WireMockRule", Boolean.valueOf(false)), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J preVisit(J tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    this.doAfterVisit(new ChangeType("com.github.tomakehurst.wiremock.junit.WireMockRule", "com.github.tomakehurst.wiremock.junit5.WireMockExtension", Boolean.valueOf(true)).getVisitor());
                }
                return tree;
            }

            public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                J.NewClass n = (J.NewClass)super.visitNewClass(newClass, (Object)ctx);
                if (newWiremockRule.matches(n)) {
                    this.maybeAddImport("com.github.tomakehurst.wiremock.junit5.WireMockExtension");
                    this.doAfterVisit(new ChangeType("org.junit.Rule", "org.junit.jupiter.api.extension.RegisterExtension", Boolean.valueOf(true)).getVisitor());
                    Expression arg = (Expression)n.getArguments().get(0);
                    JavaParser.Builder wiremockParser = JavaParser.fromJavaVersion().dependsOn(new String[]{"package com.github.tomakehurst.wiremock.junit5;import com.github.tomakehurst.wiremock.core.Options;public class WireMockExtension {  public native static Builder newInstance();  public static class Builder {    public native Builder options(Options options);    public native Builder failOnUnmatchedRequests(boolean failOnUnmatched);    public native WireMockExtension build();  }}", "package com.github.tomakehurst.wiremock.core;public class WireMockConfiguration implements Options {  public static native WireMockConfiguration options();  public native WireMockConfiguration port(int portNumber);  public native WireMockConfiguration dynamicPort();  public native WireMockConfiguration httpsPort(Integer httpsPort);  public native WireMockConfiguration dynamicHttpsPort();}", "package com.github.tomakehurst.wiremock.core;public interface Options {}"});
                    if (arg instanceof J.Empty) {
                        String newWiremockExtension = "WireMockExtension.newInstance().build()";
                        return JavaTemplate.builder((String)newWiremockExtension).imports(new String[]{"com.github.tomakehurst.wiremock.junit5.WireMockExtension"}).javaParser(wiremockParser).build().apply(this.getCursor(), n.getCoordinates().replace(), new Object[0]);
                    }
                    JavaType.ShallowClass optsType = JavaType.ShallowClass.build((String)"com.github.tomakehurst.wiremock.core.Options");
                    if (TypeUtils.isAssignableTo((JavaType)optsType, (JavaType)arg.getType())) {
                        String newWiremockExtension = "WireMockExtension.newInstance().options(#{any(com.github.tomakehurst.wiremock.core.Options)})";
                        if (n.getArguments().size() > 1) {
                            newWiremockExtension = newWiremockExtension + ".failOnUnmatchedRequests(#{any(boolean)})";
                            return JavaTemplate.builder((String)(newWiremockExtension + ".build()")).imports(new String[]{"com.github.tomakehurst.wiremock.junit5.WireMockExtension"}).javaParser(wiremockParser).build().apply(this.updateCursor((Tree)n), n.getCoordinates().replace(), new Object[]{arg, n.getArguments().get(1)});
                        }
                        return JavaTemplate.builder((String)(newWiremockExtension + ".build()")).imports(new String[]{"com.github.tomakehurst.wiremock.junit5.WireMockExtension"}).javaParser(wiremockParser).build().apply(this.updateCursor((Tree)n), n.getCoordinates().replace(), new Object[]{arg});
                    }
                    this.maybeAddImport("com.github.tomakehurst.wiremock.core.WireMockConfiguration");
                    String newWiremockExtension = "WireMockExtension.newInstance().options(WireMockConfiguration.options().port(#{any(int)})";
                    if (n.getArguments().size() > 1) {
                        newWiremockExtension = newWiremockExtension + ".httpsPort(#{any(java.lang.Integer)})";
                        return JavaTemplate.builder((String)(newWiremockExtension + ").build()")).imports(new String[]{"com.github.tomakehurst.wiremock.core.WireMockConfiguration"}).imports(new String[]{"com.github.tomakehurst.wiremock.junit5.WireMockExtension"}).javaParser(wiremockParser).build().apply(this.updateCursor((Tree)n), n.getCoordinates().replace(), new Object[]{arg, n.getArguments().get(1)});
                    }
                    return JavaTemplate.builder((String)(newWiremockExtension + ").build()")).imports(new String[]{"com.github.tomakehurst.wiremock.core.WireMockConfiguration"}).imports(new String[]{"com.github.tomakehurst.wiremock.junit5.WireMockExtension"}).javaParser(wiremockParser).build().apply(this.updateCursor((Tree)n), n.getCoordinates().replace(), new Object[]{arg});
                }
                return n;
            }
        });
    }

    public List<Recipe> getRecipeList() {
        return Collections.singletonList(new UpgradeDependencyVersion("com.github.tomakehurst", "wiremock*", "2.x", null, Boolean.valueOf(true), Collections.emptyList()));
    }
}

