/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.time.Duration;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class UseExplicitIsEmpty
extends Recipe {
    private static final MethodMatcher ASSERT_THAT = new MethodMatcher("org.assertj.core.api.Assertions assertThat(..)");
    private static final MethodMatcher IS_TRUE = new MethodMatcher("org.assertj.core.api.AbstractBooleanAssert isTrue()");
    private static final MethodMatcher IS_FALSE = new MethodMatcher("org.assertj.core.api.AbstractBooleanAssert isFalse()");
    private static final MethodMatcher IS_EMPTY = new MethodMatcher("java.util.Collection isEmpty()");

    public String getDisplayName() {
        return "Use AssertJ `isEmpty()` on collections";
    }

    public String getDescription() {
        return "Convert AssertJ `assertThat(collection.isEmpty()).isTrue()` to `assertThat(collection).isEmpty()` and `assertThat(collection.isEmpty()).isFalse()` to `assertThat(collection).isNotEmpty()`.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.assertj.core.api.Assertions", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation m, ExecutionContext ctx) {
                J.MethodInvocation method = super.visitMethodInvocation(m, (Object)ctx);
                boolean isTrue = IS_TRUE.matches(method);
                if (!isTrue && !IS_FALSE.matches(method)) {
                    return method;
                }
                if (!(method.getSelect() instanceof J.MethodInvocation)) {
                    return method;
                }
                if (!ASSERT_THAT.matches((J.MethodInvocation)method.getSelect())) {
                    return method;
                }
                J.MethodInvocation assertThat = (J.MethodInvocation)method.getSelect();
                if (!(assertThat.getArguments().get(0) instanceof J.MethodInvocation)) {
                    return method;
                }
                J.MethodInvocation isEmpty = (J.MethodInvocation)assertThat.getArguments().get(0);
                if (!IS_EMPTY.matches(isEmpty)) {
                    return method;
                }
                Expression collection = isEmpty.getSelect();
                String template = isTrue ? "assertThat(#{any()}).isEmpty();" : "assertThat(#{any()}).isNotEmpty();";
                return (J.MethodInvocation)JavaTemplate.builder((String)template).contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24"})).build().apply(this.updateCursor((Tree)method), method.getCoordinates().replace(), new Object[]{collection});
            }
        });
    }
}

