/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeMethodTargetToStatic;
import org.openrewrite.java.DeleteStatement;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class MockUtilsToStatic
extends Recipe {
    public String getDisplayName() {
        return "Use static form of Mockito `MockUtil`";
    }

    public String getDescription() {
        return "Best-effort attempt to remove Mockito `MockUtil` instances.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.mockito.internal.util.MockUtil", Boolean.valueOf(false)), (TreeVisitor)new MockUtilsToStaticVisitor());
    }

    public static class MockUtilsToStaticVisitor
    extends JavaVisitor<ExecutionContext> {
        private static final MethodMatcher METHOD_MATCHER = new MethodMatcher("org.mockito.internal.util.MockUtil <constructor>()");
        private final ChangeMethodTargetToStatic changeMethodTargetToStatic = new ChangeMethodTargetToStatic("org.mockito.internal.util.MockUtil *(..)", "org.mockito.internal.util.MockUtil", null, null);

        public J visitCompilationUnit(J.CompilationUnit compilationUnit, ExecutionContext ctx) {
            J.CompilationUnit cu = (J.CompilationUnit)super.visitCompilationUnit(compilationUnit, (Object)ctx);
            cu = (J.CompilationUnit)this.changeMethodTargetToStatic.getVisitor().visitNonNull((Tree)cu, (Object)ctx);
            return cu;
        }

        public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
            if (METHOD_MATCHER.matches(newClass)) {
                Cursor parent = this.getCursor().dropParentUntil(J.class::isInstance);
                if (parent.getValue() instanceof J.VariableDeclarations.NamedVariable) {
                    Object namedVar = parent.dropParentUntil(J.class::isInstance).getValue();
                    if (namedVar instanceof J.VariableDeclarations) {
                        this.doAfterVisit((TreeVisitor)new DeleteStatement((Statement)((J.VariableDeclarations)namedVar)));
                    }
                }
            }
            return super.visitNewClass(newClass, (Object)ctx);
        }
    }
}

