/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class AssertFalseNegationToAssertTrue
extends Recipe {
    private static final MethodMatcher ASSERT_FALSE = new MethodMatcher("org.junit.jupiter.api.Assertions assertFalse(..)");

    public String getDisplayName() {
        return "Replace JUnit `assertFalse(!<boolean>)` to `assertTrue(<boolean>)`";
    }

    public String getDescription() {
        return "Using `assertTrue` is simpler and more clear.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            JavaParser.Builder<?, ?> javaParser = null;

            private JavaParser.Builder<?, ?> javaParser(ExecutionContext ctx) {
                if (this.javaParser == null) {
                    this.javaParser = JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5.9"});
                }
                return this.javaParser;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (ASSERT_FALSE.matches((MethodCall)method) && this.isUnaryOperatorNot(method)) {
                    Object[] args;
                    StringBuilder sb = new StringBuilder();
                    if (mi.getSelect() == null) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        this.maybeAddImport("org.junit.jupiter.api.Assertions", "assertTrue");
                    } else {
                        sb.append("Assertions.");
                    }
                    sb.append("assertTrue(#{any(java.lang.Boolean)}");
                    J.Unary unary = (J.Unary)method.getArguments().get(0);
                    if (method.getArguments().size() == 2) {
                        args = new Object[]{unary.getExpression(), mi.getArguments().get(1)};
                        sb.append(", #{any()}");
                    } else {
                        args = new Object[]{unary.getExpression()};
                    }
                    sb.append(")");
                    JavaTemplate t = mi.getSelect() == null ? JavaTemplate.builder((String)sb.toString()).contextSensitive().staticImports(new String[]{"org.junit.jupiter.api.Assertions.assertTrue"}).javaParser(this.javaParser(ctx)).build() : JavaTemplate.builder((String)sb.toString()).contextSensitive().imports(new String[]{"org.junit.jupiter.api.Assertions"}).javaParser(this.javaParser(ctx)).build();
                    return (J.MethodInvocation)t.apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), args);
                }
                return mi;
            }

            private boolean isUnaryOperatorNot(J.MethodInvocation method) {
                if (!method.getArguments().isEmpty() && method.getArguments().get(0) instanceof J.Unary) {
                    J.Unary unary = (J.Unary)method.getArguments().get(0);
                    return unary.getOperator().equals((Object)J.Unary.Type.Not);
                }
                return false;
            }
        };
    }
}

