/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.dependencies.UpgradeDependencyVersion;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class UpdateMockWebServer
extends Recipe {
    private static final AnnotationMatcher RULE_MATCHER = new AnnotationMatcher("@org.junit.Rule");
    private static final AnnotationMatcher AFTER_EACH_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.AfterEach");
    private static final String AFTER_EACH_FQN = "org.junit.jupiter.api.AfterEach";
    private static final String MOCK_WEB_SERVER_FQN = "okhttp3.mockwebserver.MockWebServer";
    private static final String IO_EXCEPTION_FQN = "java.io.IOException";
    private static final String MOCK_WEBSERVER_VARIABLE = "mock-web-server-variable";
    private static final String AFTER_EACH_METHOD = "after-each-method";

    public String getDisplayName() {
        return "OkHttp 3.x `MockWebServer` `@Rule` To 4.x `MockWebServer`";
    }

    public String getDescription() {
        return "Replace usages of okhttp3 3.x `@Rule` MockWebServer with 4.x `MockWebServer`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.junit.Rule", Boolean.valueOf(false)), new UsesType(MOCK_WEB_SERVER_FQN, Boolean.valueOf(false))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            @Nullable
            private JavaParser.Builder<?, ?> javaParser;

            private JavaParser.Builder<?, ?> javaParser(ExecutionContext ctx) {
                if (this.javaParser == null) {
                    this.javaParser = JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-4.13", "junit-jupiter-api-5.9", "apiguardian-api-1.1", "mockwebserver-3.14"});
                }
                return this.javaParser;
            }

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                J.Identifier mockWebServerVariable = (J.Identifier)this.getCursor().pollMessage(UpdateMockWebServer.MOCK_WEBSERVER_VARIABLE);
                J.MethodDeclaration afterEachMethod = (J.MethodDeclaration)this.getCursor().pollMessage(UpdateMockWebServer.AFTER_EACH_METHOD);
                if (mockWebServerVariable != null) {
                    if (afterEachMethod == null) {
                        cd = (J.ClassDeclaration)JavaTemplate.builder((String)"@AfterEach\nvoid afterEachTest() throws IOException {#{any(okhttp3.mockwebserver.MockWebServer)}.close();\n}").contextSensitive().imports(new String[]{UpdateMockWebServer.AFTER_EACH_FQN, UpdateMockWebServer.MOCK_WEB_SERVER_FQN, UpdateMockWebServer.IO_EXCEPTION_FQN}).javaParser(this.javaParser(ctx)).build().apply(this.updateCursor((Tree)cd), cd.getBody().getCoordinates().lastStatement(), new Object[]{mockWebServerVariable});
                        this.maybeAddImport(UpdateMockWebServer.AFTER_EACH_FQN);
                        this.maybeAddImport(UpdateMockWebServer.IO_EXCEPTION_FQN);
                    } else {
                        for (Statement statement2 : cd.getBody().getStatements()) {
                            if (statement2 != afterEachMethod) continue;
                            cd = (J.ClassDeclaration)JavaTemplate.builder((String)"#{any(okhttp3.mockwebserver.MockWebServer)}.close();").contextSensitive().imports(new String[]{UpdateMockWebServer.AFTER_EACH_FQN, UpdateMockWebServer.MOCK_WEB_SERVER_FQN, UpdateMockWebServer.IO_EXCEPTION_FQN}).javaParser(this.javaParser(ctx)).build().apply(this.updateCursor((Tree)cd), Objects.requireNonNull(afterEachMethod.getBody()).getCoordinates().lastStatement(), new Object[]{mockWebServerVariable});
                        }
                        cd = (J.ClassDeclaration)this.autoFormat((J)cd.withBody(cd.getBody().withStatements(ListUtils.map((List)cd.getBody().getStatements(), statement -> {
                            if (statement.isScope((Tree)afterEachMethod)) {
                                J.MethodDeclaration method = (J.MethodDeclaration)statement;
                                if (method.getBody() != null && (method.getThrows() == null || method.getThrows().stream().noneMatch(n -> TypeUtils.isOfClassType((JavaType)n.getType(), (String)UpdateMockWebServer.IO_EXCEPTION_FQN)))) {
                                    J.Identifier ioExceptionIdent = new J.Identifier(UUID.randomUUID(), Space.format((String)" "), Markers.EMPTY, "IOException", (JavaType)JavaType.ShallowClass.build((String)UpdateMockWebServer.IO_EXCEPTION_FQN), null);
                                    method = method.withThrows(ListUtils.concat((List)method.getThrows(), (Object)ioExceptionIdent));
                                    this.maybeAddImport(UpdateMockWebServer.IO_EXCEPTION_FQN);
                                }
                                statement = method;
                            }
                            return statement;
                        }))), ctx);
                    }
                    this.maybeRemoveImport("org.junit.Rule");
                }
                return cd;
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations variableDeclarations = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                JavaType.FullyQualified fieldType = variableDeclarations.getTypeAsFullyQualified();
                if (TypeUtils.isOfClassType((JavaType)fieldType, (String)UpdateMockWebServer.MOCK_WEB_SERVER_FQN) && (variableDeclarations = variableDeclarations.withLeadingAnnotations(ListUtils.map((List)variableDeclarations.getLeadingAnnotations(), annotation -> {
                    if (RULE_MATCHER.matches(annotation)) {
                        return null;
                    }
                    return annotation;
                }))).getLeadingAnnotations().isEmpty()) {
                    variableDeclarations = variableDeclarations.withModifiers(Space.formatFirstPrefix((List)variableDeclarations.getModifiers(), (Space)Space.EMPTY));
                }
                if (multiVariable != variableDeclarations) {
                    this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, UpdateMockWebServer.MOCK_WEBSERVER_VARIABLE, (Object)((J.VariableDeclarations.NamedVariable)variableDeclarations.getVariables().get(0)).getName());
                }
                return variableDeclarations;
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
                for (J.Annotation annotation : md.getLeadingAnnotations()) {
                    if (!AFTER_EACH_MATCHER.matches(annotation)) continue;
                    this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, UpdateMockWebServer.AFTER_EACH_METHOD, (Object)md);
                    break;
                }
                return md;
            }
        });
    }

    public List<Recipe> getRecipeList() {
        return Collections.singletonList(new UpgradeDependencyVersion("com.squareup.okhttp3", "mockwebserver", "4.X", null, Boolean.valueOf(false), Collections.emptyList()));
    }
}

