/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.hamcrest;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public class HamcrestMatcherToAssertJ
extends Recipe {
    @Option(displayName="Hamcrest Matcher", description="The Hamcrest `Matcher` to migrate to JUnit5.", example="equalTo", required=false)
    @Nullable
    String matcher;
    @Option(displayName="AssertJ Assertion", description="The AssertJ method to migrate to.", example="isEqualTo", required=false)
    @Nullable
    String assertion;

    public String getDisplayName() {
        return "Migrate from Hamcrest `Matcher` to AssertJ";
    }

    public String getDescription() {
        return "Migrate from Hamcrest `Matcher` to AssertJ assertions.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod("org.hamcrest.Matchers " + this.matcher + "(..)"), (TreeVisitor)new MigrateToAssertJVisitor());
    }

    public HamcrestMatcherToAssertJ() {
    }

    @ConstructorProperties(value={"matcher", "assertion"})
    public HamcrestMatcherToAssertJ(@Nullable String matcher, @Nullable String assertion) {
        this.matcher = matcher;
        this.assertion = assertion;
    }

    private class MigrateToAssertJVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher assertThatMatcher = new MethodMatcher("org.hamcrest.MatcherAssert assertThat(..)");
        private final MethodMatcher matchersMatcher;
        private final MethodMatcher subMatcher;

        private MigrateToAssertJVisitor() {
            this.matchersMatcher = new MethodMatcher("org.hamcrest.Matchers " + HamcrestMatcherToAssertJ.this.matcher + "(..)");
            this.subMatcher = new MethodMatcher("org.hamcrest.Matchers *(org.hamcrest.Matcher)");
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            if (this.assertThatMatcher.matches((MethodCall)mi)) {
                if (mi.getArguments().size() == 2) {
                    return this.handleTwoArgumentCase(mi, ctx);
                }
                if (mi.getArguments().size() == 3) {
                    return this.handleThreeArgumentCase(mi, ctx);
                }
            }
            return mi;
        }

        private J.MethodInvocation handleTwoArgumentCase(J.MethodInvocation mi, ExecutionContext ctx) {
            Expression actualArgument = (Expression)mi.getArguments().get(0);
            Expression matcherArgument = (Expression)mi.getArguments().get(1);
            if (!this.matchersMatcher.matches(matcherArgument) || this.subMatcher.matches(matcherArgument)) {
                return mi;
            }
            String actual = this.typeToIndicator(actualArgument.getType());
            List originalArguments = ((J.MethodInvocation)matcherArgument).getArguments().stream().filter(a -> !(a instanceof J.Empty)).collect(Collectors.toList());
            String argumentsTemplate = originalArguments.stream().map(a -> this.typeToIndicator(a.getType())).collect(Collectors.joining(", "));
            JavaTemplate template = JavaTemplate.builder((String)String.format("assertThat(%s).%s(%s)", actual, HamcrestMatcherToAssertJ.this.assertion, argumentsTemplate)).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24"})).staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).build();
            this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat");
            this.maybeRemoveImport("org.hamcrest.Matchers." + HamcrestMatcherToAssertJ.this.matcher);
            this.maybeRemoveImport("org.hamcrest.MatcherAssert.assertThat");
            ArrayList<Object> templateArguments = new ArrayList<Object>();
            templateArguments.add(actualArgument);
            templateArguments.addAll(originalArguments);
            return (J.MethodInvocation)template.apply(this.getCursor(), mi.getCoordinates().replace(), templateArguments.toArray());
        }

        private J.MethodInvocation handleThreeArgumentCase(J.MethodInvocation mi, ExecutionContext ctx) {
            Expression reasonArgument = (Expression)mi.getArguments().get(0);
            Expression actualArgument = (Expression)mi.getArguments().get(1);
            Expression matcherArgument = (Expression)mi.getArguments().get(2);
            if (!this.matchersMatcher.matches(matcherArgument) || this.subMatcher.matches(matcherArgument)) {
                return mi;
            }
            String actual = this.typeToIndicator(actualArgument.getType());
            List originalArguments = ((J.MethodInvocation)matcherArgument).getArguments().stream().filter(a -> !(a instanceof J.Empty)).collect(Collectors.toList());
            String argumentsTemplate = originalArguments.stream().map(a -> this.typeToIndicator(a.getType())).collect(Collectors.joining(", "));
            JavaTemplate template = JavaTemplate.builder((String)String.format("assertThat(%s).as(#{any(String)}).%s(%s)", actual, HamcrestMatcherToAssertJ.this.assertion, argumentsTemplate)).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24"})).staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).build();
            this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat");
            this.maybeRemoveImport("org.hamcrest.Matchers." + HamcrestMatcherToAssertJ.this.matcher);
            this.maybeRemoveImport("org.hamcrest.MatcherAssert.assertThat");
            ArrayList<Object> templateArguments = new ArrayList<Object>();
            templateArguments.add(actualArgument);
            templateArguments.add(reasonArgument);
            templateArguments.addAll(originalArguments);
            return (J.MethodInvocation)template.apply(this.getCursor(), mi.getCoordinates().replace(), templateArguments.toArray());
        }

        private String typeToIndicator(JavaType type) {
            if (type instanceof JavaType.Array) {
                String str = (type = ((JavaType.Array)type).getElemType()) instanceof JavaType.Primitive || type.toString().startsWith("java.") ? type.toString().replaceAll("<.*>", "") : "java.lang.Object";
                return String.format("#{anyArray(%s)}", str);
            }
            String str = type instanceof JavaType.Primitive || type.toString().startsWith("java.") ? type.toString().replaceAll("<.*>", "") : "java.lang.Object";
            return String.format("#{any(%s)}", str);
        }
    }
}

