/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.hamcrest;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class RemoveIsMatcher
extends Recipe {
    static final MethodMatcher IS_MATCHER = new MethodMatcher("org.hamcrest.Matchers is(org.hamcrest.Matcher)");
    static final MethodMatcher ASSERT_THAT_MATCHER = new MethodMatcher("org.hamcrest.MatcherAssert assertThat(..)");

    public String getDisplayName() {
        return "Remove Hamcrest `is(Matcher)`";
    }

    public String getDescription() {
        return "Remove Hamcrest `is(Matcher)` ahead of migration.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation mi, ExecutionContext ctx) {
                if (ASSERT_THAT_MATCHER.matches((MethodCall)mi)) {
                    this.getCursor().putMessage("ASSERT_THAT", (Object)mi);
                } else if (IS_MATCHER.matches((MethodCall)mi) && this.getCursor().pollNearestMessage("ASSERT_THAT") != null) {
                    this.maybeRemoveImport("org.hamcrest.Matchers.is");
                    return ((Expression)mi.getArguments().get(0)).withPrefix(mi.getPrefix());
                }
                return super.visitMethodInvocation(mi, (Object)ctx);
            }
        };
    }
}

