/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Statement;

public class RemoveTryCatchFailBlocks
extends Recipe {
    private static final MethodMatcher ASSERT_FAIL_NO_ARG = new MethodMatcher("org.junit.jupiter.api.Assertions fail(..)");
    private static final MethodMatcher ASSERT_FAIL_STRING_ARG = new MethodMatcher("org.junit.jupiter.api.Assertions fail(String)");
    private static final MethodMatcher GET_MESSAGE_MATCHER = new MethodMatcher("java.lang.Throwable getMessage()");

    public String getDisplayName() {
        return "Replace `fail()` in `try-catch` blocks with `Assertions.assertDoesNotThrow(() -> { ... })`";
    }

    public String getDescription() {
        return "Replace `try-catch` blocks where `catch` merely contains a `fail(..)` statement with `Assertions.assertDoesNotThrow(() -> { ... })`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-3658");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions fail(..)", false), (TreeVisitor)new RemoveTryCatchBlocksFromUnitsTestsVisitor());
    }

    private static class RemoveTryCatchBlocksFromUnitsTestsVisitor
    extends JavaVisitor<ExecutionContext> {
        private RemoveTryCatchBlocksFromUnitsTestsVisitor() {
        }

        public J visitTry(J.Try jtry, ExecutionContext ctx) {
            J.Try try_ = (J.Try)super.visitTry(jtry, (Object)ctx);
            if (try_.getResources() != null || try_.getCatches().size() != 1) {
                return try_;
            }
            J.Try.Catch catchBlock = (J.Try.Catch)try_.getCatches().get(0);
            if (catchBlock.getBody().getStatements().size() != 1) {
                return try_;
            }
            Statement statement = (Statement)catchBlock.getBody().getStatements().get(0);
            if (!(statement instanceof J.MethodInvocation)) {
                return try_;
            }
            J.MethodInvocation failCall = (J.MethodInvocation)statement;
            if (!ASSERT_FAIL_NO_ARG.matches((MethodCall)failCall) || !ASSERT_FAIL_STRING_ARG.matches((MethodCall)failCall)) {
                return try_;
            }
            if (ASSERT_FAIL_STRING_ARG.matches((MethodCall)failCall)) {
                Expression failCallString = (Expression)failCall.getArguments().get(0);
                if (failCallString instanceof J.MethodInvocation && !GET_MESSAGE_MATCHER.matches((MethodCall)((J.MethodInvocation)failCallString))) {
                    return try_;
                }
                if (failCallString instanceof J.Literal) {
                    this.maybeAddImport("org.junit.jupiter.api.Assertions");
                    return JavaTemplate.builder((String)"Assertions.assertDoesNotThrow(() -> #{any()}, #{any(String)})").contextSensitive().imports(new String[]{"org.junit.jupiter.api.Assertions"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5.9"})).build().apply(this.getCursor(), try_.getCoordinates().replace(), new Object[]{try_.getBody(), failCallString});
                }
            }
            this.maybeAddImport("org.junit.jupiter.api.Assertions");
            return JavaTemplate.builder((String)"Assertions.assertDoesNotThrow(() -> #{any()})").contextSensitive().imports(new String[]{"org.junit.jupiter.api.Assertions"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5.9"})).build().apply(this.getCursor(), try_.getCoordinates().replace(), new Object[]{try_.getBody()});
        }
    }
}

