/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.RemoveAnnotationVisitor;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public class PowerMockitoMockStaticToMockito
extends Recipe {
    public String getDisplayName() {
        return "Replace `PowerMock.mockStatic()` with `Mockito.mockStatic()`";
    }

    public String getDescription() {
        return "Replaces `PowerMockito.mockStatic()` by `Mockito.mockStatic()`. Removes the `@PrepareForTest` annotation.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.powermock..*", Boolean.valueOf(false)), new UsesType("org.mockito..*", Boolean.valueOf(false))}), (TreeVisitor)new PowerMockitoToMockitoVisitor());
    }

    private static class PowerMockitoToMockitoVisitor
    extends JavaVisitor<ExecutionContext> {
        private static final String MOCKED_STATIC = "org.mockito.MockedStatic";
        private static final String POWER_MOCK_RUNNER = "org.powermock.modules.junit4.PowerMockRunner";
        private static final String POWER_MOCK_CONFIG = "org.powermock.configuration.PowerMockConfiguration";
        private static final String POWER_MOCK_TEST_CASE = "org.powermock.modules.testng.PowerMockTestCase";
        private static final MethodMatcher MOCKED_STATIC_MATCHER = new MethodMatcher("org.mockito.Mockito mockStatic(..)");
        private static final MethodMatcher MOCKED_STATIC_CLOSE_MATCHER = new MethodMatcher("org.mockito.ScopedMock close(..)", true);
        private static final MethodMatcher MOCKITO_VERIFY_MATCHER = new MethodMatcher("org.mockito.Mockito verify(..)");
        private static final MethodMatcher MOCKITO_WHEN_MATCHER = new MethodMatcher("org.mockito.Mockito when(..)");
        private static final MethodMatcher MOCKITO_STATIC_METHOD_MATCHER = new MethodMatcher("org.mockito..* *(..)");
        private static final AnnotationMatcher PREPARE_FOR_TEST_MATCHER = new AnnotationMatcher("@org.powermock.core.classloader.annotations.PrepareForTest");
        private static final AnnotationMatcher RUN_WITH_POWER_MOCK_RUNNER_MATCHER = new AnnotationMatcher("@org.junit.runner.RunWith(org.powermock.modules.junit4.PowerMockRunner.class)");
        private static final String MOCKED_TYPES_FIELDS = "mockedTypesFields";
        private static final String MOCK_STATIC_INVOCATIONS = "mockStaticInvocationsByClassName";
        private static final MethodMatcher DYNAMIC_WHEN_METHOD_MATCHER = new MethodMatcher("org.mockito.Mockito when(java.lang.Class, String, ..)");
        private static final String MOCK_PREFIX = "mocked";
        private static final String TEST_GROUP = "testGroup";
        private String setUpMethodAnnotationSignature;
        private String setUpMethodAnnotation;
        private String tearDownMethodAnnotationSignature;
        private String tearDownMethodAnnotation;
        private String additionalClasspathResource;
        private String setUpImportToAdd;
        private String tearDownImportToAdd;
        private String tearDownMethodAnnotationParameters = "";

        private PowerMockitoToMockitoVisitor() {
        }

        @Nullable
        public J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                boolean useTestNg = !FindAnnotations.find((J)((J)tree), (String)"@org.testng.annotations.Test").isEmpty();
                this.initTestFrameworkInfo(useTestNg);
            }
            return (J)super.visit(tree, (Object)ctx);
        }

        public J visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            this.getCursor().putMessage(MOCK_STATIC_INVOCATIONS, new HashMap());
            ArrayList<Expression> mockedStaticClasses = new ArrayList<Expression>();
            for (J.Annotation j : classDecl.getAllAnnotations()) {
                List arguments;
                if (!PREPARE_FOR_TEST_MATCHER.matches(j) || (arguments = j.getArguments()) == null || arguments.isEmpty()) continue;
                mockedStaticClasses.addAll(ListUtils.flatMap((List)arguments, a -> {
                    if (a instanceof J.NewArray && ((J.NewArray)a).getInitializer() != null) {
                        return ((J.NewArray)a).getInitializer();
                    }
                    if (a instanceof J.Assignment && ((J.NewArray)((J.Assignment)a).getAssignment()).getInitializer() != null) {
                        return ((J.NewArray)((J.Assignment)a).getAssignment()).getInitializer();
                    }
                    if (a instanceof J.FieldAccess) {
                        return a;
                    }
                    return null;
                }));
                this.doAfterVisit((TreeVisitor)new RemoveAnnotationVisitor(PREPARE_FOR_TEST_MATCHER));
            }
            for (J.Annotation annotation : classDecl.getAllAnnotations()) {
                if (!RUN_WITH_POWER_MOCK_RUNNER_MATCHER.matches(annotation)) continue;
                this.doAfterVisit((TreeVisitor)new RemoveAnnotationVisitor(RUN_WITH_POWER_MOCK_RUNNER_MATCHER));
                this.maybeRemoveImport(POWER_MOCK_RUNNER);
            }
            J.ClassDeclaration cd = (J.ClassDeclaration)super.visitClassDeclaration(classDecl, (Object)ctx);
            cd = this.removeExtension(cd, POWER_MOCK_CONFIG);
            cd = this.removeExtension(cd, POWER_MOCK_TEST_CASE);
            if (!mockedStaticClasses.isEmpty()) {
                cd = this.maybeAddSetUpMethodBody(cd, ctx);
                cd = this.maybeAddTearDownMethodBody(cd, ctx);
                cd = this.addFieldDeclarationForMockedTypes(cd, ctx, mockedStaticClasses);
                return super.visitClassDeclaration(cd, (Object)ctx);
            }
            return cd;
        }

        public J visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J.MethodDeclaration m = (J.MethodDeclaration)super.visitMethodDeclaration(method, (Object)ctx);
            AnnotationMatcher tearDownAnnotationMatcher = new AnnotationMatcher(this.tearDownMethodAnnotationSignature);
            if (m.getAllAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)tearDownAnnotationMatcher).matches(arg_0))) {
                return this.addCloseStaticMocksOnDemandStatement(m, ctx);
            }
            AnnotationMatcher setUpAnnotationMatcher = new AnnotationMatcher(this.setUpMethodAnnotationSignature);
            if (m.getAllAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)setUpAnnotationMatcher).matches(arg_0))) {
                m = this.moveMockStaticMethodToSetUp(m, ctx);
            }
            return m;
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
            Map mockStaticInvocationsByClassName = (Map)this.getCursor().getNearestMessage(MOCK_STATIC_INVOCATIONS);
            if (mockStaticInvocationsByClassName != null && MOCKED_STATIC_MATCHER.matches((MethodCall)mi)) {
                Optional firstArgument = mi.getArguments().stream().findFirst();
                firstArgument.ifPresent(expression -> {
                    mockStaticInvocationsByClassName.put(expression.toString(), mi);
                    this.getCursor().putMessageOnFirstEnclosing(J.MethodDeclaration.class, MOCK_STATIC_INVOCATIONS, (Object)mockStaticInvocationsByClassName);
                });
            }
            if (DYNAMIC_WHEN_METHOD_MATCHER.matches((MethodCall)mi)) {
                return this.modifyDynamicWhenMethodInvocation(mi);
            }
            if (MOCKITO_WHEN_MATCHER.matches((MethodCall)mi) || MOCKITO_VERIFY_MATCHER.matches((MethodCall)mi)) {
                return this.modifyWhenMethodInvocation(mi);
            }
            if (MOCKED_STATIC_MATCHER.matches((MethodCall)mi)) {
                this.determineTestGroups();
                if (this.getCursor().firstEnclosing(J.Assignment.class) == null) {
                    return null;
                }
            }
            return mi;
        }

        private static boolean isFieldAlreadyDefined(J.Block classBody, String fieldName) {
            for (Statement statement : classBody.getStatements()) {
                if (!(statement instanceof J.VariableDeclarations)) continue;
                for (J.VariableDeclarations.NamedVariable namedVariable : ((J.VariableDeclarations)statement).getVariables()) {
                    if (!namedVariable.getSimpleName().equals(fieldName)) continue;
                    return true;
                }
            }
            return false;
        }

        @Nullable
        private static J.MethodDeclaration getFirstTestMethod(List<J.MethodDeclaration> methods) {
            for (J.MethodDeclaration methodDeclaration : methods) {
                for (J.Annotation annotation : methodDeclaration.getLeadingAnnotations()) {
                    if (!"Test".equals(annotation.getSimpleName())) continue;
                    return methodDeclaration;
                }
            }
            return null;
        }

        private static boolean hasMethodWithAnnotation(J.ClassDeclaration classDecl, AnnotationMatcher annotationMatcher) {
            for (Statement statement : classDecl.getBody().getStatements()) {
                if (!(statement instanceof J.MethodDeclaration)) continue;
                J.MethodDeclaration methodDeclaration = (J.MethodDeclaration)statement;
                List allAnnotations = methodDeclaration.getAllAnnotations();
                for (J.Annotation annotation : allAnnotations) {
                    if (!annotationMatcher.matches(annotation)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isStaticMockAlreadyClosed(J.Identifier staticMock, J.Block methodBody) {
            for (Statement statement : methodBody.getStatements()) {
                J.MethodInvocation methodInvocation;
                if (!(statement instanceof J.MethodInvocation) || !MOCKED_STATIC_CLOSE_MATCHER.matches((MethodCall)(methodInvocation = (J.MethodInvocation)statement)) || !(methodInvocation.getSelect() instanceof J.Identifier) || !((J.Identifier)methodInvocation.getSelect()).getSimpleName().equals(staticMock.getSimpleName())) continue;
                return true;
            }
            return false;
        }

        private static boolean isStaticMockAlreadyOpened(J.Identifier staticMock, J.Block methodBody) {
            for (Statement statement : methodBody.getStatements()) {
                J.MethodInvocation methodInvocation;
                if (!(statement instanceof J.MethodInvocation) || !MOCKED_STATIC_MATCHER.matches((MethodCall)(methodInvocation = (J.MethodInvocation)statement)) || !(methodInvocation.getSelect() instanceof J.Identifier) || !((J.Identifier)methodInvocation.getSelect()).getSimpleName().equals(staticMock.getSimpleName())) continue;
                return true;
            }
            return false;
        }

        private J.MethodDeclaration moveMockStaticMethodToSetUp(J.MethodDeclaration m, ExecutionContext ctx) {
            Map mockStaticInvocations = (Map)this.getCursor().getNearestMessage(MOCK_STATIC_INVOCATIONS);
            if (mockStaticInvocations != null) {
                for (Map.Entry<J.Identifier, Expression> mockedTypesFieldEntry : this.getMockedTypesFields().entrySet()) {
                    String className;
                    J.MethodInvocation methodInvocation;
                    J.Block methodBody = m.getBody();
                    if (methodBody == null || PowerMockitoToMockitoVisitor.isStaticMockAlreadyOpened(mockedTypesFieldEntry.getKey(), methodBody) || (methodInvocation = (J.MethodInvocation)mockStaticInvocations.get(className = mockedTypesFieldEntry.getValue().toString())) == null) continue;
                    m = (J.MethodDeclaration)JavaTemplate.builder((String)"mocked#{any(org.mockito.MockedStatic)} = #{any(org.mockito.Mockito)};").contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-core-3.12"})).build().apply(new Cursor(this.getCursor().getParentOrThrow(), (Object)m), methodBody.getCoordinates().firstStatement(), new Object[]{mockedTypesFieldEntry.getKey(), methodInvocation});
                }
            }
            return m;
        }

        private J.MethodDeclaration addCloseStaticMocksOnDemandStatement(J.MethodDeclaration m, ExecutionContext ctx) {
            for (Map.Entry<J.Identifier, Expression> mockedTypesField : this.getMockedTypesFields().entrySet()) {
                J.Block methodBody = m.getBody();
                if (methodBody == null || PowerMockitoToMockitoVisitor.isStaticMockAlreadyClosed(mockedTypesField.getKey(), methodBody)) continue;
                m = (J.MethodDeclaration)JavaTemplate.builder((String)"#{any(org.mockito.MockedStatic)}.closeOnDemand();").contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-core-3.12"})).build().apply(new Cursor(this.getCursor().getParentOrThrow(), (Object)m), methodBody.getCoordinates().lastStatement(), new Object[]{mockedTypesField.getKey()});
            }
            return m;
        }

        private void determineTestGroups() {
            J.MethodDeclaration methodDeclarationCursor;
            if (this.getCursor().getNearestMessage(TEST_GROUP) == null && (methodDeclarationCursor = (J.MethodDeclaration)this.getCursor().firstEnclosing(J.MethodDeclaration.class)) != null) {
                Optional<J.Annotation> testAnnotation = methodDeclarationCursor.getLeadingAnnotations().stream().filter(annotation -> annotation.getSimpleName().equals("Test")).findFirst();
                testAnnotation.ifPresent(ta -> {
                    if (ta.getArguments() != null) {
                        this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, TEST_GROUP, (Object)ta.getArguments());
                    }
                });
            }
        }

        private J.MethodInvocation modifyDynamicWhenMethodInvocation(J.MethodInvocation method) {
            List arguments = method.getArguments();
            String declaringClassName = ((J.FieldAccess)arguments.get(0)).getTarget().toString();
            J.Identifier mockedField = this.getFieldIdentifier(MOCK_PREFIX + declaringClassName);
            if (mockedField != null) {
                arguments.remove(0);
                J.Literal calledMethod = (J.Literal)arguments.get(0);
                arguments.remove(0);
                String stringOfArguments = arguments.stream().map(Object::toString).collect(Collectors.joining(","));
                method = (J.MethodInvocation)JavaTemplate.builder((String)"() -> #{}.#{}(#{})").contextSensitive().build().apply(new Cursor(this.getCursor().getParentOrThrow(), (Object)method), method.getCoordinates().replaceArguments(), new Object[]{declaringClassName, Objects.requireNonNull(calledMethod.getValue()).toString(), stringOfArguments});
                method = method.withSelect((Expression)mockedField);
            }
            return method;
        }

        private J.ClassDeclaration removeExtension(J.ClassDeclaration classDecl, String extensionFQN) {
            TypeTree extension = classDecl.getExtends();
            if (extension != null && TypeUtils.isAssignableTo((String)extensionFQN, (JavaType)extension.getType())) {
                classDecl = classDecl.withExtends(null);
                this.maybeRemoveImport(extensionFQN);
            }
            return classDecl;
        }

        private void initTestFrameworkInfo(boolean useTestNg) {
            String annotationPackage;
            String tearDownMethodAnnotationName;
            String setUpMethodAnnotationName;
            if (!useTestNg) {
                setUpMethodAnnotationName = "BeforeEach";
                tearDownMethodAnnotationName = "AfterEach";
                annotationPackage = "org.junit.jupiter.api";
                this.additionalClasspathResource = "junit-jupiter-api-5.9";
            } else {
                setUpMethodAnnotationName = "BeforeMethod";
                tearDownMethodAnnotationName = "AfterMethod";
                annotationPackage = "org.testng.annotations";
                this.additionalClasspathResource = "testng-7.7";
                this.tearDownMethodAnnotationParameters = "(alwaysRun = true)";
            }
            this.setUpMethodAnnotation = "@" + setUpMethodAnnotationName;
            this.tearDownMethodAnnotation = "@" + tearDownMethodAnnotationName;
            this.setUpMethodAnnotationSignature = "@" + annotationPackage + "." + setUpMethodAnnotationName;
            this.tearDownMethodAnnotationSignature = "@" + annotationPackage + "." + tearDownMethodAnnotationName;
            this.setUpImportToAdd = annotationPackage + "." + setUpMethodAnnotationName;
            this.tearDownImportToAdd = annotationPackage + "." + tearDownMethodAnnotationName;
        }

        private Map<J.Identifier, Expression> getMockedTypesFields() {
            return (Map)this.getCursor().getNearestMessage(MOCKED_TYPES_FIELDS, new LinkedHashMap());
        }

        private J.ClassDeclaration addFieldDeclarationForMockedTypes(J.ClassDeclaration classDecl, ExecutionContext ctx, List<Expression> mockedStaticClasses) {
            Map invocationByClassName = (Map)this.getCursor().getNearestMessage(MOCK_STATIC_INVOCATIONS);
            if (invocationByClassName == null || invocationByClassName.isEmpty()) {
                return classDecl;
            }
            LinkedHashMap<J.Identifier, Expression> mockedTypesIdentifiers = new LinkedHashMap<J.Identifier, Expression>();
            for (Expression mockedStaticClass : mockedStaticClasses) {
                JavaType.FullyQualified fullyQualifiedMockedType;
                JavaType.Parameterized classType = TypeUtils.asParameterized((JavaType)mockedStaticClass.getType());
                if (classType == null || (fullyQualifiedMockedType = TypeUtils.asFullyQualified((JavaType)((JavaType)classType.getTypeParameters().get(0)))) == null) continue;
                String classlessTypeName = fullyQualifiedMockedType.getClassName();
                if (invocationByClassName.get(classlessTypeName + ".class") == null) {
                    this.maybeRemoveImport(fullyQualifiedMockedType.getFullyQualifiedName());
                    continue;
                }
                String mockedTypedFieldName = MOCK_PREFIX + classlessTypeName;
                if (PowerMockitoToMockitoVisitor.isFieldAlreadyDefined(classDecl.getBody(), mockedTypedFieldName)) continue;
                classDecl = (J.ClassDeclaration)JavaTemplate.builder((String)"private MockedStatic<#{}> mocked#{};").contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-core-3.12"})).staticImports(new String[]{"org.mockito.Mockito.mockStatic"}).imports(new String[]{MOCKED_STATIC}).build().apply(new Cursor(this.getCursor().getParentOrThrow(), (Object)classDecl), classDecl.getBody().getCoordinates().firstStatement(), new Object[]{classlessTypeName, classlessTypeName});
                J.VariableDeclarations mockField = (J.VariableDeclarations)classDecl.getBody().getStatements().get(0);
                mockedTypesIdentifiers.put(((J.VariableDeclarations.NamedVariable)mockField.getVariables().get(0)).getName(), mockedStaticClass);
            }
            this.getCursor().putMessage(MOCKED_TYPES_FIELDS, mockedTypesIdentifiers);
            this.maybeAutoFormat((J)classDecl, (J)classDecl.withPrefix(classDecl.getPrefix().withWhitespace("")), (J)classDecl.getName(), ctx, this.getCursor());
            this.maybeAddImport(MOCKED_STATIC);
            this.maybeAddImport("org.mockito.Mockito", "mockStatic");
            return classDecl;
        }

        private J.ClassDeclaration maybeAddSetUpMethodBody(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            String testGroupsAsString = this.getTestGroupsAsString();
            return this.maybeAddMethodWithAnnotation(classDecl, ctx, "setUpStaticMocks", this.setUpMethodAnnotationSignature, this.setUpMethodAnnotation, this.additionalClasspathResource, this.setUpImportToAdd, testGroupsAsString);
        }

        private String getTestGroupsAsString() {
            List testGroups = (List)this.getCursor().getNearestMessage(TEST_GROUP);
            String testGroupsAsString = "";
            if (testGroups != null) {
                testGroupsAsString = "(" + testGroups.stream().map(Object::toString).collect(Collectors.joining(",")) + ")";
            }
            return testGroupsAsString;
        }

        private J.ClassDeclaration maybeAddTearDownMethodBody(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            String testGroupsAsString = this.getTestGroupsAsString().isEmpty() ? this.tearDownMethodAnnotationParameters : this.getTestGroupsAsString();
            return this.maybeAddMethodWithAnnotation(classDecl, ctx, "tearDownStaticMocks", this.tearDownMethodAnnotationSignature, this.tearDownMethodAnnotation, this.additionalClasspathResource, this.tearDownImportToAdd, testGroupsAsString);
        }

        private J.ClassDeclaration maybeAddMethodWithAnnotation(J.ClassDeclaration classDecl, ExecutionContext ctx, String methodName, String methodAnnotationSignature, String methodAnnotationToAdd, String additionalClasspathResource, String importToAdd, String methodAnnotationParameters) {
            if (PowerMockitoToMockitoVisitor.hasMethodWithAnnotation(classDecl, new AnnotationMatcher(methodAnnotationSignature))) {
                return classDecl;
            }
            J.MethodDeclaration firstTestMethod = PowerMockitoToMockitoVisitor.getFirstTestMethod(classDecl.getBody().getStatements().stream().filter(J.MethodDeclaration.class::isInstance).map(J.MethodDeclaration.class::cast).collect(Collectors.toList()));
            this.maybeAddImport(importToAdd);
            return (J.ClassDeclaration)JavaTemplate.builder((String)(methodAnnotationToAdd + methodAnnotationParameters + " void " + methodName + "() {}")).contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{additionalClasspathResource})).imports(new String[]{importToAdd}).build().apply(new Cursor(this.getCursor().getParentOrThrow(), (Object)classDecl), firstTestMethod != null ? firstTestMethod.getCoordinates().before() : classDecl.getBody().getCoordinates().lastStatement(), new Object[0]);
        }

        private J.MethodInvocation modifyWhenMethodInvocation(J.MethodInvocation whenMethod) {
            List methodArguments = whenMethod.getArguments();
            List staticMethodInvocationsInArguments = methodArguments.stream().filter(J.MethodInvocation.class::isInstance).map(J.MethodInvocation.class::cast).filter(methodInvocation -> !MOCKITO_STATIC_METHOD_MATCHER.matches((MethodCall)methodInvocation)).filter(methodInvocation -> methodInvocation.getMethodType() != null).filter(methodInvocation -> methodInvocation.getMethodType().hasFlags(new Flag[]{Flag.Static})).collect(Collectors.toList());
            if (staticMethodInvocationsInArguments.size() == 1) {
                JavaType.Method methodType;
                J.MethodInvocation staticMI = (J.MethodInvocation)staticMethodInvocationsInArguments.get(0);
                String declaringClassName = this.getDeclaringClassName(staticMI);
                J.Identifier mockedStaticClassField = this.getFieldIdentifier(MOCK_PREFIX + declaringClassName);
                if (mockedStaticClassField == null) {
                    return whenMethod;
                }
                Object lambdaInvocation = staticMI.getArguments().stream().map(Expression::getType).noneMatch(Objects::nonNull) ? (Expression)JavaTemplate.builder((String)(declaringClassName + "::" + staticMI.getSimpleName())).contextSensitive().build().apply(new Cursor(this.getCursor(), (Object)staticMI), staticMI.getCoordinates().replace(), new Object[0]) : ((methodType = staticMI.getMethodType()) != null ? (Expression)JavaTemplate.builder((String)"() -> #{any()}").contextSensitive().build().apply(new Cursor(this.getCursor(), (Object)staticMI), staticMI.getCoordinates().replace(), new Object[]{staticMI}) : staticMI);
                if (Collections.replaceAll(methodArguments, staticMI, lambdaInvocation)) {
                    whenMethod = whenMethod.withSelect((Expression)mockedStaticClassField);
                    whenMethod = whenMethod.withArguments(methodArguments);
                }
            }
            return whenMethod;
        }

        @Nullable
        private String getDeclaringClassName(J.MethodInvocation mi) {
            JavaType.Method methodType = mi.getMethodType();
            if (methodType != null) {
                JavaType.FullyQualified declaringType = methodType.getDeclaringType();
                return declaringType.getClassName();
            }
            return null;
        }

        @Nullable
        private J.Identifier getFieldIdentifier(String fieldName) {
            return this.getMockedTypesFields().keySet().stream().filter(identifier -> identifier.getSimpleName().equals(fieldName)).findFirst().orElseGet(() -> {
                J.ClassDeclaration cd = (J.ClassDeclaration)this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance).getValue();
                return cd.getBody().getStatements().stream().filter(J.VariableDeclarations.class::isInstance).map(variableDeclarations -> ((J.VariableDeclarations)variableDeclarations).getVariables()).flatMap(Collection::stream).filter(namedVariable -> namedVariable.getSimpleName().equals(fieldName)).map(J.VariableDeclarations.NamedVariable::getName).findFirst().orElse(null);
            });
        }
    }
}

