/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.jmockit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public final class JMockitExpectationsToMockito
extends Recipe {
    public String getDisplayName() {
        return "Rewrite JMockit Expectations";
    }

    public String getDescription() {
        return "Rewrites JMockit `Expectations` blocks to Mockito statements.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("mockit.Expectations", Boolean.valueOf(false)), (TreeVisitor)new RewriteExpectationsVisitor());
    }

    @NonNull
    public String toString() {
        return "JMockitExpectationsToMockito()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JMockitExpectationsToMockito)) {
            return false;
        }
        JMockitExpectationsToMockito other = (JMockitExpectationsToMockito)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof JMockitExpectationsToMockito;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class RewriteExpectationsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final String VOID_RESULT_TEMPLATE = "doNothing().when(#{any(java.lang.String)});";
        private static final String PRIMITIVE_RESULT_TEMPLATE = "when(#{any()}).thenReturn(#{});";
        private static final String OBJECT_RESULT_TEMPLATE = "when(#{any()}).thenReturn(#{any(java.lang.String)});";
        private static final String THROWABLE_RESULT_TEMPLATE = "when(#{any()}).thenThrow(#{any()});";
        private static final Set<String> JMOCKIT_ARGUMENT_MATCHERS = new HashSet<String>();
        private static final Map<String, String> MOCKITO_COLLECTION_MATCHERS;

        private RewriteExpectationsVisitor() {
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDeclaration, ExecutionContext ctx) {
            J.MethodDeclaration md = super.visitMethodDeclaration(methodDeclaration, (Object)ctx);
            if (md.getBody() == null) {
                return md;
            }
            J.Block cursorLocation = md.getBody();
            J.Block newBody = md.getBody();
            List statements = md.getBody().getStatements();
            try {
                for (int bodyStatementIndex = 0; bodyStatementIndex < statements.size(); ++bodyStatementIndex) {
                    J.Identifier clazz;
                    J.NewClass nc;
                    Statement s = (Statement)statements.get(bodyStatementIndex);
                    if (!(s instanceof J.NewClass) || !((nc = (J.NewClass)s).getClazz() instanceof J.Identifier) || !TypeUtils.isAssignableTo((String)"mockit.Expectations", (JavaType)(clazz = (J.Identifier)nc.getClazz()).getType())) continue;
                    assert (nc.getBody() != null && !nc.getBody().getStatements().isEmpty()) : "Expectations block is empty";
                    assert (nc.getBody().getStatements().size() == 1) : "Expectations block is malformed";
                    this.maybeRemoveImport("mockit.Expectations");
                    JavaCoordinates coordinates = nc.getCoordinates().replace();
                    J.Block expectationsBlock = (J.Block)nc.getBody().getStatements().get(0);
                    ArrayList<Object> templateParams = new ArrayList<Object>();
                    int mockitoStatementIndex = 0;
                    for (Statement expectationStatement : expectationsBlock.getStatements()) {
                        if (expectationStatement instanceof J.MethodInvocation) {
                            if (!templateParams.isEmpty()) {
                                newBody = this.rewriteMethodBody(ctx, templateParams, cursorLocation, coordinates);
                                int newStatementIndex = bodyStatementIndex + mockitoStatementIndex;
                                coordinates = ((Statement)newBody.getStatements().get(newStatementIndex)).getCoordinates().after();
                                cursorLocation = newBody;
                                templateParams = new ArrayList();
                                ++mockitoStatementIndex;
                            }
                            templateParams.add(expectationStatement);
                            continue;
                        }
                        templateParams.add(((J.Assignment)expectationStatement).getAssignment());
                    }
                    if (templateParams.isEmpty()) continue;
                    newBody = this.rewriteMethodBody(ctx, templateParams, cursorLocation, coordinates);
                }
            }
            catch (Exception e) {
                return md;
            }
            return md.withBody(newBody);
        }

        private J.Block rewriteMethodBody(ExecutionContext ctx, List<Object> templateParams, Object cursorLocation, JavaCoordinates coordinates) {
            String methodName;
            Expression result = null;
            if (templateParams.size() == 1) {
                methodName = "doNothing";
            } else if (templateParams.size() == 2) {
                methodName = "when";
                result = (Expression)templateParams.get(1);
            } else {
                throw new IllegalStateException("Unexpected number of template params: " + templateParams.size());
            }
            this.maybeAddImport("org.mockito.Mockito", methodName);
            this.rewriteArgumentMatchers(ctx, templateParams);
            return (J.Block)JavaTemplate.builder((String)RewriteExpectationsVisitor.getMockitoStatementTemplate(result)).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-core-3.12"})).staticImports(new String[]{"org.mockito.Mockito." + methodName}).build().apply(new Cursor(this.getCursor(), cursorLocation), coordinates, templateParams.toArray());
        }

        private void rewriteArgumentMatchers(ExecutionContext ctx, List<Object> bodyTemplateParams) {
            J.MethodInvocation invocation = (J.MethodInvocation)bodyTemplateParams.get(0);
            ArrayList<Expression> newArguments = new ArrayList<Expression>(invocation.getArguments().size());
            for (Expression methodArgument : invocation.getArguments()) {
                String fqn;
                String className;
                String template;
                String argumentMatcher;
                if (!RewriteExpectationsVisitor.isArgumentMatcher(methodArgument)) {
                    newArguments.add(methodArgument);
                    continue;
                }
                ArrayList<Object> argumentTemplateParams = new ArrayList<Object>();
                if (!(methodArgument instanceof J.TypeCast)) {
                    argumentMatcher = ((J.Identifier)methodArgument).getSimpleName();
                    template = argumentMatcher + "()";
                    newArguments.add(this.rewriteMethodArgument(ctx, argumentMatcher, template, methodArgument, argumentTemplateParams));
                    continue;
                }
                J.TypeCast tc = (J.TypeCast)methodArgument;
                argumentMatcher = ((J.Identifier)tc.getExpression()).getSimpleName();
                JavaType typeCastType = tc.getType();
                if (typeCastType instanceof JavaType.Parameterized) {
                    className = ((JavaType.Parameterized)typeCastType).getType().getClassName();
                    fqn = ((JavaType.Parameterized)typeCastType).getType().getFullyQualifiedName();
                } else if (typeCastType instanceof JavaType.FullyQualified) {
                    className = ((JavaType.FullyQualified)typeCastType).getClassName();
                    fqn = ((JavaType.FullyQualified)typeCastType).getFullyQualifiedName();
                } else {
                    throw new IllegalStateException("Unexpected J.TypeCast type: " + typeCastType);
                }
                if (MOCKITO_COLLECTION_MATCHERS.containsKey(fqn)) {
                    argumentMatcher = MOCKITO_COLLECTION_MATCHERS.get(fqn);
                    template = argumentMatcher + "()";
                } else {
                    argumentTemplateParams.add(JavaTemplate.builder((String)"#{}.class").javaParser(JavaParser.fromJavaVersion()).imports(new String[]{fqn}).build().apply(new Cursor(this.getCursor(), (Object)tc), tc.getCoordinates().replace(), new Object[]{className}));
                    template = argumentMatcher + "(#{any(java.lang.Class)})";
                }
                newArguments.add(this.rewriteMethodArgument(ctx, argumentMatcher, template, methodArgument, argumentTemplateParams));
            }
            bodyTemplateParams.set(0, invocation.withArguments(newArguments));
        }

        private Expression rewriteMethodArgument(ExecutionContext ctx, String argumentMatcher, String template, Expression methodArgument, List<Object> templateParams) {
            this.maybeAddImport("org.mockito.Mockito", argumentMatcher);
            return (Expression)JavaTemplate.builder((String)template).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-core-3.12"})).staticImports(new String[]{"org.mockito.Mockito." + argumentMatcher}).build().apply(new Cursor(this.getCursor(), (Object)methodArgument), methodArgument.getCoordinates().replace(), templateParams.toArray());
        }

        private static boolean isArgumentMatcher(Expression expression) {
            if (expression instanceof J.TypeCast) {
                expression = ((J.TypeCast)expression).getExpression();
            }
            if (!(expression instanceof J.Identifier)) {
                return false;
            }
            J.Identifier identifier = (J.Identifier)expression;
            return JMOCKIT_ARGUMENT_MATCHERS.contains(identifier.getSimpleName());
        }

        private static String getMockitoStatementTemplate(Expression result) {
            String template;
            if (result == null) {
                return VOID_RESULT_TEMPLATE;
            }
            JavaType resultType = Objects.requireNonNull(result.getType());
            if (resultType instanceof JavaType.Primitive) {
                template = PRIMITIVE_RESULT_TEMPLATE;
            } else if (resultType instanceof JavaType.Class) {
                template = TypeUtils.isAssignableTo((String)Throwable.class.getName(), (JavaType)resultType) ? THROWABLE_RESULT_TEMPLATE : OBJECT_RESULT_TEMPLATE;
            } else {
                throw new IllegalStateException("Unexpected expression type for template: " + result.getType());
            }
            return template;
        }

        static {
            JMOCKIT_ARGUMENT_MATCHERS.add("anyString");
            JMOCKIT_ARGUMENT_MATCHERS.add("anyInt");
            JMOCKIT_ARGUMENT_MATCHERS.add("anyLong");
            JMOCKIT_ARGUMENT_MATCHERS.add("anyDouble");
            JMOCKIT_ARGUMENT_MATCHERS.add("anyFloat");
            JMOCKIT_ARGUMENT_MATCHERS.add("anyBoolean");
            JMOCKIT_ARGUMENT_MATCHERS.add("anyByte");
            JMOCKIT_ARGUMENT_MATCHERS.add("anyChar");
            JMOCKIT_ARGUMENT_MATCHERS.add("anyShort");
            JMOCKIT_ARGUMENT_MATCHERS.add("any");
            MOCKITO_COLLECTION_MATCHERS = new HashMap<String, String>();
            MOCKITO_COLLECTION_MATCHERS.put("java.util.List", "anyList");
            MOCKITO_COLLECTION_MATCHERS.put("java.util.Set", "anySet");
            MOCKITO_COLLECTION_MATCHERS.put("java.util.Collection", "anyCollection");
            MOCKITO_COLLECTION_MATCHERS.put("java.util.Iterable", "anyIterable");
            MOCKITO_COLLECTION_MATCHERS.put("java.util.Map", "anyMap");
        }
    }
}

