/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public class IsEqualToEmptyString
extends Recipe {
    private static final MethodMatcher IS_EQUAL_TO = new MethodMatcher("org.assertj.core.api.AbstractStringAssert isEqualTo(java.lang.String)");

    public String getDisplayName() {
        return "Convert `assertThat(String).isEqualTo(\"\")` to `isEmpty()`";
    }

    public String getDescription() {
        return "Adopt idiomatic AssertJ assertion for empty Strings.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(IS_EQUAL_TO), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (IS_EQUAL_TO.matches((MethodCall)mi) && J.Literal.isLiteralValue((Expression)((Expression)mi.getArguments().get(0)), (Object)"")) {
                    JavaType.Method isEmptyMethodType = mi.getMethodType().withName("isEmpty");
                    return mi.withName(mi.getName().withSimpleName("isEmpty").withType((JavaType)isEmptyMethodType)).withMethodType(isEmptyMethodType).withArguments(Collections.emptyList());
                }
                return mi;
            }
        });
    }
}

