/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.jmockit;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.testing.jmockit.ArgumentMatchersRewriter;
import org.openrewrite.java.testing.jmockit.JMockitBlockType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

class JMockitBlockRewriter {
    private static final String WHEN_TEMPLATE_PREFIX = "when(#{any()}).";
    private static final String VERIFY_TEMPLATE_PREFIX = "verify(#{any()}";
    private static final String LENIENT_TEMPLATE_PREFIX = "lenient().";
    private static final String RETURN_TEMPLATE_PREFIX = "thenReturn(";
    private static final String THROW_TEMPLATE_PREFIX = "thenThrow(";
    private static final String LITERAL_TEMPLATE_FIELD = "#{}";
    private static final String ANY_TEMPLATE_FIELD = "#{any()}";
    private static final String MOCKITO_IMPORT_FQN_PREFX = "org.mockito.Mockito";
    private final JavaVisitor<ExecutionContext> visitor;
    private final ExecutionContext ctx;
    private final J.NewClass newExpectations;
    private final JMockitBlockType blockType;
    private final int bodyStatementIndex;
    private J.Block methodBody;
    private JavaCoordinates nextStatementCoordinates;
    private boolean rewriteFailed = false;
    private int numStatementsAdded = 0;

    private static String getObjectTemplateField(String fqn) {
        return "#{any(" + fqn + ")}";
    }

    boolean isRewriteFailed() {
        return this.rewriteFailed;
    }

    JMockitBlockRewriter(JavaVisitor<ExecutionContext> visitor, ExecutionContext ctx, J.Block methodBody, J.NewClass newExpectations, int bodyStatementIndex, JMockitBlockType blockType) {
        this.visitor = visitor;
        this.ctx = ctx;
        this.methodBody = methodBody;
        this.newExpectations = newExpectations;
        this.bodyStatementIndex = bodyStatementIndex;
        this.blockType = blockType;
        this.nextStatementCoordinates = newExpectations.getCoordinates().replace();
    }

    J.Block rewriteMethodBody() {
        this.visitor.maybeRemoveImport(this.blockType.getFqn());
        assert (this.newExpectations.getBody() != null);
        J.Block jmockitBlock = (J.Block)this.newExpectations.getBody().getStatements().get(0);
        if (jmockitBlock.getStatements().isEmpty()) {
            this.removeBlock();
            return this.methodBody;
        }
        ArgumentMatchersRewriter amr = new ArgumentMatchersRewriter(this.visitor, this.ctx, jmockitBlock);
        jmockitBlock = amr.rewriteJMockitBlock();
        ArrayList methodInvocationsToRewrite = new ArrayList();
        int methodInvocationIdx = -1;
        for (Statement jmockitBlockStatement : jmockitBlock.getStatements()) {
            J.MethodInvocation invocation;
            if (jmockitBlockStatement instanceof J.MethodInvocation && (invocation = (J.MethodInvocation)jmockitBlockStatement).getSelect() != null && !invocation.getName().getSimpleName().equals("returns")) {
                ++methodInvocationIdx;
                methodInvocationsToRewrite.add(new ArrayList());
            }
            if (methodInvocationIdx == -1) continue;
            ((List)methodInvocationsToRewrite.get(methodInvocationIdx)).add(jmockitBlockStatement);
        }
        if (this.nextStatementCoordinates.isReplacement()) {
            this.removeBlock();
        }
        methodInvocationsToRewrite.forEach(this::rewriteMethodInvocation);
        return this.methodBody;
    }

    private void rewriteMethodInvocation(List<Statement> statementsToRewrite) {
        MockInvocationResults mockInvocationResults = JMockitBlockRewriter.buildMockInvocationResults(statementsToRewrite);
        if (mockInvocationResults == null) {
            this.rewriteFailed = true;
            return;
        }
        J.MethodInvocation invocation = (J.MethodInvocation)statementsToRewrite.get(0);
        boolean hasResults = !mockInvocationResults.getResults().isEmpty();
        boolean hasTimes = mockInvocationResults.hasAnyTimes();
        if (hasResults) {
            this.rewriteResult(invocation, mockInvocationResults.getResults(), hasTimes);
        }
        if (!(hasResults || hasTimes || this.blockType != JMockitBlockType.Expectations && this.blockType != JMockitBlockType.Verifications)) {
            this.rewriteVerify(invocation, null, "");
            return;
        }
        if (mockInvocationResults.getTimes() != null) {
            this.rewriteVerify(invocation, mockInvocationResults.getTimes(), "times");
        }
        if (mockInvocationResults.getMinTimes() != null) {
            this.rewriteVerify(invocation, mockInvocationResults.getMinTimes(), "atLeast");
        }
        if (mockInvocationResults.getMaxTimes() != null) {
            this.rewriteVerify(invocation, mockInvocationResults.getMaxTimes(), "atMost");
        }
    }

    private void removeBlock() {
        this.methodBody = (J.Block)JavaTemplate.builder((String)"").javaParser(JavaParser.fromJavaVersion()).build().apply(new Cursor(this.visitor.getCursor(), (Object)this.methodBody), this.nextStatementCoordinates, new Object[0]);
        this.setNextStatementCoordinates(0);
    }

    private void rewriteResult(J.MethodInvocation invocation, List<Expression> results, boolean hasTimes) {
        boolean lenient = this.blockType == JMockitBlockType.NonStrictExpectations && !hasTimes;
        String template = this.getWhenTemplate(results, lenient);
        if (template == null) {
            this.rewriteFailed = true;
            return;
        }
        ArrayList<Object> templateParams = new ArrayList<Object>();
        templateParams.add(invocation);
        templateParams.addAll(results);
        boolean bl = this.rewriteFailed = !this.rewriteTemplate(template, templateParams, this.nextStatementCoordinates);
        if (this.rewriteFailed) {
            return;
        }
        this.setNextStatementCoordinates(++this.numStatementsAdded);
        this.visitor.maybeAddImport(MOCKITO_IMPORT_FQN_PREFX, "when", false);
        if (lenient) {
            this.visitor.maybeAddImport(MOCKITO_IMPORT_FQN_PREFX, "lenient");
        }
    }

    private void rewriteVerify(J.MethodInvocation invocation, @Nullable Expression times, String verificationMode) {
        if (invocation.getSelect() == null) {
            return;
        }
        ArrayList<Object> templateParams = new ArrayList<Object>();
        templateParams.add(invocation.getSelect());
        if (times != null) {
            templateParams.add(times);
        }
        templateParams.add(invocation.getName().getSimpleName());
        String verifyTemplate = JMockitBlockRewriter.getVerifyTemplate(invocation.getArguments(), verificationMode, templateParams);
        JavaCoordinates verifyCoordinates = this.blockType == JMockitBlockType.Verifications ? this.nextStatementCoordinates : this.methodBody.getCoordinates().lastStatement();
        boolean bl = this.rewriteFailed = !this.rewriteTemplate(verifyTemplate, templateParams, verifyCoordinates);
        if (this.rewriteFailed) {
            return;
        }
        if (this.blockType == JMockitBlockType.Verifications) {
            this.setNextStatementCoordinates(++this.numStatementsAdded);
        }
        this.visitor.maybeAddImport(MOCKITO_IMPORT_FQN_PREFX, "verify", false);
        if (!verificationMode.isEmpty()) {
            this.visitor.maybeAddImport(MOCKITO_IMPORT_FQN_PREFX, verificationMode);
        }
    }

    private void setNextStatementCoordinates(int numStatementsAdded) {
        if (numStatementsAdded <= 0 && this.bodyStatementIndex == 0) {
            this.nextStatementCoordinates = this.methodBody.getCoordinates().firstStatement();
            return;
        }
        int lastStatementIdx = this.bodyStatementIndex + numStatementsAdded - 1;
        if (lastStatementIdx >= this.methodBody.getStatements().size()) {
            this.rewriteFailed = true;
            return;
        }
        this.nextStatementCoordinates = ((Statement)this.methodBody.getStatements().get(lastStatementIdx)).getCoordinates().after();
    }

    private boolean rewriteTemplate(String template, List<Object> templateParams, JavaCoordinates rewriteCoords) {
        int numStatementsBefore = this.methodBody.getStatements().size();
        this.methodBody = (J.Block)JavaTemplate.builder((String)template).javaParser(JavaParser.fromJavaVersion().classpathFromResources(this.ctx, new String[]{"mockito-core-3.12"})).staticImports(new String[]{"org.mockito.Mockito.*"}).build().apply(new Cursor(this.visitor.getCursor(), (Object)this.methodBody), rewriteCoords, templateParams.toArray());
        return this.methodBody.getStatements().size() > numStatementsBefore;
    }

    private @Nullable String getWhenTemplate(List<Expression> results, boolean lenient) {
        boolean buildingResults = false;
        StringBuilder templateBuilder = new StringBuilder();
        if (lenient) {
            templateBuilder.append(LENIENT_TEMPLATE_PREFIX);
        }
        templateBuilder.append(WHEN_TEMPLATE_PREFIX);
        for (Expression result : results) {
            JavaType resultType = result.getType();
            if (result instanceof J.Literal) {
                JMockitBlockRewriter.appendToTemplate(templateBuilder, buildingResults, RETURN_TEMPLATE_PREFIX, LITERAL_TEMPLATE_FIELD);
            } else if (resultType instanceof JavaType.Primitive) {
                String primitiveTemplateField = JMockitBlockRewriter.getPrimitiveTemplateField((JavaType.Primitive)resultType);
                if (primitiveTemplateField == null) {
                    return null;
                }
                JMockitBlockRewriter.appendToTemplate(templateBuilder, buildingResults, RETURN_TEMPLATE_PREFIX, primitiveTemplateField);
            } else if (TypeUtils.isAssignableTo((String)Throwable.class.getName(), (JavaType)resultType)) {
                JMockitBlockRewriter.appendToTemplate(templateBuilder, buildingResults, THROW_TEMPLATE_PREFIX, ANY_TEMPLATE_FIELD);
            } else if (resultType instanceof JavaType.Class) {
                JMockitBlockRewriter.appendToTemplate(templateBuilder, buildingResults, RETURN_TEMPLATE_PREFIX, JMockitBlockRewriter.getObjectTemplateField(((JavaType.Class)resultType).getFullyQualifiedName()));
            } else if (resultType instanceof JavaType.Parameterized) {
                JMockitBlockRewriter.appendToTemplate(templateBuilder, buildingResults, RETURN_TEMPLATE_PREFIX, JMockitBlockRewriter.getObjectTemplateField(((JavaType.Parameterized)resultType).getType().getFullyQualifiedName()));
            } else {
                return null;
            }
            buildingResults = true;
        }
        templateBuilder.append(");");
        return templateBuilder.toString();
    }

    private static void appendToTemplate(StringBuilder templateBuilder, boolean buildingResults, String templatePrefix, String templateField) {
        if (!buildingResults) {
            templateBuilder.append(templatePrefix);
        } else {
            templateBuilder.append(", ");
        }
        templateBuilder.append(templateField);
    }

    private static String getVerifyTemplate(List<Expression> arguments, String verificationMode, List<Object> templateParams) {
        StringBuilder templateBuilder = new StringBuilder(VERIFY_TEMPLATE_PREFIX);
        if (!verificationMode.isEmpty()) {
            templateBuilder.append(", ").append(verificationMode).append("(#{any(int)})");
        }
        templateBuilder.append(").#{}(");
        if (arguments.isEmpty()) {
            templateBuilder.append(");");
            return templateBuilder.toString();
        }
        boolean hasArgument = false;
        for (Expression argument : arguments) {
            if (argument instanceof J.Empty) continue;
            if (argument instanceof J.Literal) {
                templateBuilder.append(((J.Literal)argument).getValueSource());
            } else {
                templateBuilder.append(ANY_TEMPLATE_FIELD);
                templateParams.add(argument);
            }
            hasArgument = true;
            templateBuilder.append(", ");
        }
        if (hasArgument) {
            templateBuilder.delete(templateBuilder.length() - 2, templateBuilder.length());
        }
        templateBuilder.append(");");
        return templateBuilder.toString();
    }

    private static @Nullable MockInvocationResults buildMockInvocationResults(List<Statement> expectationStatements) {
        MockInvocationResults resultWrapper = new MockInvocationResults();
        block12: for (int i = 1; i < expectationStatements.size(); ++i) {
            Statement expectationStatement = expectationStatements.get(i);
            if (expectationStatement instanceof J.MethodInvocation) {
                J.MethodInvocation invocation = (J.MethodInvocation)expectationStatement;
                for (Expression argument : invocation.getArguments()) {
                    resultWrapper.addResult(argument);
                }
                continue;
            }
            J.Assignment assignment = (J.Assignment)expectationStatement;
            String variableName = JMockitBlockRewriter.getVariableNameFromAssignment(assignment);
            if (variableName == null) {
                return null;
            }
            switch (variableName) {
                case "result": {
                    resultWrapper.addResult(assignment.getAssignment());
                    continue block12;
                }
                case "times": {
                    resultWrapper.setTimes(assignment.getAssignment());
                    continue block12;
                }
                case "minTimes": {
                    resultWrapper.setMinTimes(assignment.getAssignment());
                    continue block12;
                }
                case "maxTimes": {
                    resultWrapper.setMaxTimes(assignment.getAssignment());
                }
            }
        }
        return resultWrapper;
    }

    private static @Nullable String getVariableNameFromAssignment(J.Assignment assignment) {
        J.FieldAccess fieldAccess;
        if (assignment.getVariable() instanceof J.Identifier) {
            return ((J.Identifier)assignment.getVariable()).getSimpleName();
        }
        if (assignment.getVariable() instanceof J.FieldAccess && (fieldAccess = (J.FieldAccess)assignment.getVariable()).getTarget() instanceof J.Identifier) {
            return fieldAccess.getSimpleName();
        }
        return null;
    }

    private static @Nullable String getPrimitiveTemplateField(JavaType.Primitive primitiveType) {
        switch (primitiveType) {
            case Boolean: {
                return "#{any(boolean)}";
            }
            case Byte: {
                return "#{any(byte)}";
            }
            case Char: {
                return "#{any(char)}";
            }
            case Double: {
                return "#{any(double)}";
            }
            case Float: {
                return "#{any(float)}";
            }
            case Int: {
                return "#{any(int)}";
            }
            case Long: {
                return "#{any(long)}";
            }
            case Short: {
                return "#{any(short)}";
            }
            case String: {
                return "#{any(String)}";
            }
            case Null: {
                return ANY_TEMPLATE_FIELD;
            }
        }
        return null;
    }

    private static class MockInvocationResults {
        private final List<Expression> results = new ArrayList<Expression>();
        private Expression times;
        private Expression minTimes;
        private Expression maxTimes;

        private void addResult(Expression result) {
            this.results.add(result);
        }

        private boolean hasAnyTimes() {
            return this.times != null || this.minTimes != null || this.maxTimes != null;
        }

        @Generated
        public MockInvocationResults() {
        }

        @Generated
        public List<Expression> getResults() {
            return this.results;
        }

        @Generated
        public Expression getTimes() {
            return this.times;
        }

        @Generated
        public Expression getMinTimes() {
            return this.minTimes;
        }

        @Generated
        public Expression getMaxTimes() {
            return this.maxTimes;
        }

        @Generated
        public void setTimes(Expression times) {
            this.times = times;
        }

        @Generated
        public void setMinTimes(Expression minTimes) {
            this.minTimes = minTimes;
        }

        @Generated
        public void setMaxTimes(Expression maxTimes) {
            this.maxTimes = maxTimes;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MockInvocationResults)) {
                return false;
            }
            MockInvocationResults other = (MockInvocationResults)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Expression> this$results = this.getResults();
            List<Expression> other$results = other.getResults();
            if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
                return false;
            }
            Expression this$times = this.getTimes();
            Expression other$times = other.getTimes();
            if (this$times == null ? other$times != null : !this$times.equals(other$times)) {
                return false;
            }
            Expression this$minTimes = this.getMinTimes();
            Expression other$minTimes = other.getMinTimes();
            if (this$minTimes == null ? other$minTimes != null : !this$minTimes.equals(other$minTimes)) {
                return false;
            }
            Expression this$maxTimes = this.getMaxTimes();
            Expression other$maxTimes = other.getMaxTimes();
            return !(this$maxTimes == null ? other$maxTimes != null : !this$maxTimes.equals(other$maxTimes));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof MockInvocationResults;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Expression> $results = this.getResults();
            result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
            Expression $times = this.getTimes();
            result = result * 59 + ($times == null ? 43 : $times.hashCode());
            Expression $minTimes = this.getMinTimes();
            result = result * 59 + ($minTimes == null ? 43 : $minTimes.hashCode());
            Expression $maxTimes = this.getMaxTimes();
            result = result * 59 + ($maxTimes == null ? 43 : $maxTimes.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JMockitBlockRewriter.MockInvocationResults(results=" + this.getResults() + ", times=" + this.getTimes() + ", minTimes=" + this.getMinTimes() + ", maxTimes=" + this.getMaxTimes() + ")";
        }
    }
}

