/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.staticanalysis.LambdaBlockToExpression;

public class AssertThrowsOnLastStatement
extends Recipe {
    public String getDisplayName() {
        return "Applies JUnit 5 `assertThrows` on last statement in lambda block only";
    }

    public String getDescription() {
        return "Applies JUnit 5 `assertThrows` on last statement in lambda block only. In rare cases may cause compilation errors if the lambda uses effectively non final variables. In some cases, tests might fail if earlier statements in the lambda block throw exceptions.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher assertThrowsMatcher = new MethodMatcher("org.junit.jupiter.api.Assertions assertThrows(java.lang.Class, org.junit.jupiter.api.function.Executable, ..)");
        return Preconditions.check((TreeVisitor)new UsesMethod(assertThrowsMatcher), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDecl, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(methodDecl, (Object)ctx);
                m = m.withBody(m.getBody().withStatements(ListUtils.flatMap((List)m.getBody().getStatements(), methodStatement -> {
                    J.VariableDeclarations.NamedVariable assertThrowsVar;
                    J.VariableDeclarations assertThrowsWithVarDec;
                    Statement statementToCheck = methodStatement;
                    if (methodStatement instanceof J.VariableDeclarations) {
                        assertThrowsWithVarDec = (J.VariableDeclarations)methodStatement;
                        List assertThrowsNamedVars = assertThrowsWithVarDec.getVariables();
                        if (assertThrowsNamedVars.size() != 1) {
                            return methodStatement;
                        }
                        assertThrowsVar = (J.VariableDeclarations.NamedVariable)assertThrowsNamedVars.get(0);
                        statementToCheck = assertThrowsVar.getInitializer();
                    } else {
                        assertThrowsWithVarDec = null;
                        assertThrowsVar = null;
                    }
                    if (!(statementToCheck instanceof J.MethodInvocation)) {
                        return methodStatement;
                    }
                    J.MethodInvocation methodInvocation = (J.MethodInvocation)statementToCheck;
                    if (!assertThrowsMatcher.matches((MethodCall)methodInvocation)) {
                        return methodStatement;
                    }
                    List arguments = methodInvocation.getArguments();
                    if (arguments.size() <= 1) {
                        return methodStatement;
                    }
                    Expression arg = (Expression)arguments.get(1);
                    if (!(arg instanceof J.Lambda)) {
                        return methodStatement;
                    }
                    J.Lambda lambda = (J.Lambda)arg;
                    if (!(lambda.getBody() instanceof J.Block)) {
                        return methodStatement;
                    }
                    J.Block body = (J.Block)lambda.getBody();
                    List lambdaStatements = body.getStatements();
                    if (lambdaStatements.size() <= 1) {
                        return methodStatement;
                    }
                    return ListUtils.map((List)lambdaStatements, (idx, lambdaStatement) -> {
                        if (idx < lambdaStatements.size() - 1) {
                            return (Statement)lambdaStatement.withPrefix(methodStatement.getPrefix().withComments(Collections.emptyList()));
                        }
                        J.MethodInvocation newAssertThrows = methodInvocation.withArguments(ListUtils.map((List)arguments, (argIdx, argument) -> {
                            if (argIdx == 1) {
                                return lambda.withBody((J)body.withStatements(Collections.singletonList(lambdaStatement)));
                            }
                            return argument;
                        }));
                        if (assertThrowsWithVarDec == null) {
                            return newAssertThrows;
                        }
                        J.VariableDeclarations.NamedVariable newAssertThrowsVar = assertThrowsVar.withInitializer((Expression)newAssertThrows);
                        return assertThrowsWithVarDec.withVariables(Collections.singletonList(newAssertThrowsVar));
                    });
                })));
                this.doAfterVisit(new LambdaBlockToExpression().getVisitor());
                return m;
            }
        });
    }
}

