/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveAnnotationVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public final class EnclosedToNested
extends Recipe {
    private static final String ENCLOSED = "org.junit.experimental.runners.Enclosed";
    private static final String RUN_WITH = "org.junit.runner.RunWith";
    private static final String RUN_WITH_ENCLOSED = String.format("@%s(%s.class)", "org.junit.runner.RunWith", "org.junit.experimental.runners.Enclosed");

    public String getDisplayName() {
        return "JUnit 4 `@RunWith(Enclosed.class)` to JUnit Jupiter `@Nested`";
    }

    public String getDescription() {
        return "Removes the `Enclosed` specification from a class, with `Nested` added to its inner classes by `AddMissingNested`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(ENCLOSED, Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                this.maybeRemoveImport(EnclosedToNested.ENCLOSED);
                this.maybeRemoveImport(EnclosedToNested.RUN_WITH);
                return (J.ClassDeclaration)new RemoveAnnotationVisitor(new AnnotationMatcher(RUN_WITH_ENCLOSED)).visitNonNull((Tree)cd, (Object)ctx);
            }
        });
    }

    @Generated
    public EnclosedToNested() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "EnclosedToNested()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnclosedToNested)) {
            return false;
        }
        EnclosedToNested other = (EnclosedToNested)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof EnclosedToNested;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

