/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.jmockit;

import java.util.Arrays;
import java.util.Optional;
import org.openrewrite.java.testing.jmockit.JMockitBlockType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

class JMockitUtils {
    JMockitUtils() {
    }

    static Optional<JMockitBlockType> getJMockitBlock(Statement s) {
        if (!(s instanceof J.NewClass)) {
            return Optional.empty();
        }
        J.NewClass nc = (J.NewClass)s;
        if (nc.getBody() == null || nc.getClazz() == null) {
            return Optional.empty();
        }
        JavaType type = nc.getClazz().getType();
        if (type == null) {
            return Optional.empty();
        }
        return Arrays.stream(JMockitBlockType.values()).filter(supportedType -> TypeUtils.isOfClassType((JavaType)type, (String)supportedType.getFqn())).findFirst();
    }
}

