/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class AssertTrueNegationToAssertFalse
extends Recipe {
    private static final MethodMatcher ASSERT_TRUE = new MethodMatcher("org.junit.jupiter.api.Assertions assertTrue(..)");

    public String getDisplayName() {
        return "Replace JUnit `assertTrue(!<boolean>)` to `assertFalse(<boolean>)`";
    }

    public String getDescription() {
        return "Using `assertFalse` is simpler and more clear.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            JavaParser.Builder<?, ?> javaParser = null;

            private JavaParser.Builder<?, ?> javaParser(ExecutionContext ctx) {
                if (this.javaParser == null) {
                    this.javaParser = JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5.9"});
                }
                return this.javaParser;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (ASSERT_TRUE.matches((MethodCall)mi) && this.isUnaryOperatorNot(mi)) {
                    Object[] args;
                    StringBuilder sb = new StringBuilder();
                    J.Unary unary = (J.Unary)mi.getArguments().get(0);
                    if (mi.getSelect() == null) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        this.maybeAddImport("org.junit.jupiter.api.Assertions", "assertFalse");
                    } else {
                        sb.append("Assertions.");
                    }
                    sb.append("assertFalse(#{any(java.lang.Boolean)}");
                    if (mi.getArguments().size() == 2) {
                        args = new Object[]{unary.getExpression(), mi.getArguments().get(1)};
                        sb.append(", #{any()}");
                    } else {
                        args = new Object[]{unary.getExpression()};
                    }
                    sb.append(")");
                    JavaTemplate t = mi.getSelect() == null ? JavaTemplate.builder((String)sb.toString()).contextSensitive().staticImports(new String[]{"org.junit.jupiter.api.Assertions.assertFalse"}).javaParser(this.javaParser(ctx)).build() : JavaTemplate.builder((String)sb.toString()).contextSensitive().imports(new String[]{"org.junit.jupiter.api.Assertions"}).javaParser(this.javaParser(ctx)).build();
                    return (J.MethodInvocation)t.apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), args);
                }
                return mi;
            }

            private boolean isUnaryOperatorNot(J.MethodInvocation method) {
                if (!method.getArguments().isEmpty() && method.getArguments().get(0) instanceof J.Unary) {
                    J.Unary unary = (J.Unary)method.getArguments().get(0);
                    return unary.getOperator() == J.Unary.Type.Not;
                }
                return false;
            }
        };
    }
}

