/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import com.google.errorprone.refaster.Refaster;
import java.math.BigInteger;
import org.assertj.core.api.AbstractBigIntegerAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.openrewrite.java.template.RecipeDescriptor;

@RecipeDescriptor(name="Adopt AssertJ BigInteger Assertions", description="Adopt AssertJ BigInteger Assertions. Favor semantically explicit methods (e.g. `myBigInteger.isZero()` over `myBigInteger.isEqualTo(0)`).")
public class AssertJBigIntegerRules {

    @RecipeDescriptor(name="Replace `isEqualTo(1)` with `isOne()`", description="Replace `isEqualTo(1)` with `isOne()`.")
    static final class AbstractBigIntegerAssertIsOne {
        AbstractBigIntegerAssertIsOne() {
        }

        AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> bigIntegerAssert) {
            return (AbstractBigIntegerAssert)Refaster.anyOf((Object[])new AbstractBigIntegerAssert[]{bigIntegerAssert.isEqualTo(1), (AbstractBigIntegerAssert)bigIntegerAssert.isEqualTo((Object)BigInteger.ONE)});
        }

        AbstractBigIntegerAssert<?> after(AbstractBigIntegerAssert<?> bigIntegerAssert) {
            return bigIntegerAssert.isOne();
        }
    }

    @RecipeDescriptor(name="Replace `isNotEqualTo(0)` with `isNotZero()`", description="Replace `isNotEqualTo(0)` with `isNotZero()`.")
    static final class AbstractBigIntegerAssertIsNotZero {
        AbstractBigIntegerAssertIsNotZero() {
        }

        AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> bigIntegerAssert) {
            return (AbstractBigIntegerAssert)Refaster.anyOf((Object[])new AbstractBigIntegerAssert[]{(AbstractBigIntegerAssert)bigIntegerAssert.isNotEqualTo((Object)0), (AbstractBigIntegerAssert)bigIntegerAssert.isNotEqualTo((Object)BigInteger.ZERO)});
        }

        AbstractBigIntegerAssert<?> after(AbstractBigIntegerAssert<?> bigIntegerAssert) {
            return bigIntegerAssert.isNotZero();
        }
    }

    @RecipeDescriptor(name="Replace `isEqualTo(0)` with `isZero()`", description="Replace `isEqualTo(0)` with `isZero()`.")
    static final class AbstractBigIntegerAssertIsZero {
        AbstractBigIntegerAssertIsZero() {
        }

        AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> bigIntegerAssert) {
            return (AbstractBigIntegerAssert)Refaster.anyOf((Object[])new AbstractBigIntegerAssert[]{bigIntegerAssert.isEqualTo(0), (AbstractBigIntegerAssert)bigIntegerAssert.isEqualTo((Object)BigInteger.ZERO)});
        }

        AbstractBigIntegerAssert<?> after(AbstractBigIntegerAssert<?> bigIntegerAssert) {
            return bigIntegerAssert.isZero();
        }
    }

    @RecipeDescriptor(name="Replace `isNotCloseTo` with `isNotEqualTo`", description="Replace `isNotCloseTo` with `isNotEqualTo` when `offset` or `percentage` is zero.")
    static final class AbstractBigIntegerAssertIsNotEqualTo {
        AbstractBigIntegerAssertIsNotEqualTo() {
        }

        AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> bigIntegerAssert, BigInteger n) {
            return (AbstractBigIntegerAssert)Refaster.anyOf((Object[])new AbstractBigIntegerAssert[]{bigIntegerAssert.isNotCloseTo(n, Offset.offset((Number)BigInteger.ZERO)), bigIntegerAssert.isNotCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractBigIntegerAssert<?> after(AbstractBigIntegerAssert<?> bigIntegerAssert, BigInteger n) {
            return (AbstractBigIntegerAssert)bigIntegerAssert.isNotEqualTo((Object)n);
        }
    }

    @RecipeDescriptor(name="Replace `isCloseTo` with `isEqualTo`", description="Replace `isCloseTo` with `isEqualTo` when `offset` or `percentage` is zero.")
    static final class AbstractBigIntegerAssertIsEqualTo {
        AbstractBigIntegerAssertIsEqualTo() {
        }

        AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> bigIntegerAssert, BigInteger n) {
            return (AbstractBigIntegerAssert)Refaster.anyOf((Object[])new AbstractBigIntegerAssert[]{bigIntegerAssert.isCloseTo(n, Offset.offset((Number)BigInteger.ZERO)), bigIntegerAssert.isCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractBigIntegerAssert<?> after(AbstractBigIntegerAssert<?> bigIntegerAssert, BigInteger n) {
            return (AbstractBigIntegerAssert)bigIntegerAssert.isEqualTo((Object)n);
        }
    }
}

