/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveAnnotationVisitor;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class NoInitializationForInjectMock
extends Recipe {
    public String getDisplayName() {
        return "Remove `@InjectMocks` annotation or initializer";
    }

    public String getDescription() {
        return "Remove either the `@InjectMocks` annotation from fields, or the initializer, based on the initializer.\n * In the case of a no-args constructor, remove the initializer and retain the annotation.\n * In the case of any other initializer, remove the annotation and retain the initializer.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.mockito.InjectMocks", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations.NamedVariable namedVariable;
                Expression initializer;
                J.VariableDeclarations vds = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                Set annotations = FindAnnotations.find((J)vds, (String)"@org.mockito.InjectMocks");
                if (!annotations.isEmpty() && (initializer = (namedVariable = (J.VariableDeclarations.NamedVariable)vds.getVariables().get(0)).getInitializer()) != null) {
                    if (initializer instanceof J.NewClass && (((J.NewClass)initializer).getArguments().isEmpty() || ((J.NewClass)initializer).getArguments().get(0) instanceof J.Empty)) {
                        return (J.VariableDeclarations)this.autoFormat((J)vds.withModifiers(ListUtils.map((List)vds.getModifiers(), m -> m.getType() == J.Modifier.Type.Final ? null : m)).withVariables(ListUtils.map((List)vds.getVariables(), v -> v.withInitializer(null))), ctx);
                    }
                    this.maybeRemoveImport("org.mockito.InjectMocks");
                    return (J.VariableDeclarations)new RemoveAnnotationVisitor(new AnnotationMatcher("@org.mockito.InjectMocks")).visit((Tree)vds, (Object)ctx);
                }
                return vds;
            }
        });
    }
}

