/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.hamcrest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.testing.hamcrest.RemoveNotMatcherVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class HamcrestMatcherToJUnit5
extends Recipe {
    private static final MethodMatcher MATCHER_ASSERT_MATCHER = new MethodMatcher("org.hamcrest.MatcherAssert assertThat(.., org.hamcrest.Matcher)");

    public String getDisplayName() {
        return "Migrate from Hamcrest `Matcher` to JUnit 5";
    }

    public String getDescription() {
        return "Migrate from Hamcrest `Matcher` to JUnit 5 assertions.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(MATCHER_ASSERT_MATCHER), (TreeVisitor)new MigrationFromHamcrestVisitor());
    }

    private static class MigrationFromHamcrestVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private MigrationFromHamcrestVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            if (MATCHER_ASSERT_MATCHER.matches((MethodCall)mi)) {
                Expression hamcrestMatcher;
                Expression examinedObject;
                Expression reason;
                if (mi.getArguments().size() == 2) {
                    reason = null;
                    examinedObject = (Expression)mi.getArguments().get(0);
                    hamcrestMatcher = (Expression)mi.getArguments().get(1);
                } else if (mi.getArguments().size() == 3) {
                    reason = (Expression)mi.getArguments().get(0);
                    examinedObject = (Expression)mi.getArguments().get(1);
                    hamcrestMatcher = (Expression)mi.getArguments().get(2);
                } else {
                    return mi;
                }
                if (hamcrestMatcher instanceof J.MethodInvocation) {
                    Replacement replacement;
                    J.MethodInvocation matcherInvocation = (J.MethodInvocation)hamcrestMatcher;
                    this.maybeRemoveImport("org.hamcrest.MatcherAssert.assertThat");
                    while ("not".equals(matcherInvocation.getSimpleName())) {
                        this.maybeRemoveImport("org.hamcrest.Matchers.not");
                        this.maybeRemoveImport("org.hamcrest.CoreMatchers.not");
                        matcherInvocation = (J.MethodInvocation)new RemoveNotMatcherVisitor().visit((Tree)matcherInvocation, ctx);
                    }
                    if (!(matcherInvocation.getArguments().get(0) instanceof J.Empty) && ((Expression)matcherInvocation.getArguments().get(0)).getType().toString().startsWith("org.hamcrest")) {
                        return mi;
                    }
                    boolean logicalContext = RemoveNotMatcherVisitor.getLogicalContext(matcherInvocation, ctx);
                    try {
                        replacement = Replacement.valueOf(matcherInvocation.getSimpleName().toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        return mi;
                    }
                    String assertion = logicalContext ? replacement.junitPositive : replacement.junitNegative;
                    String templateString = assertion + "(" + replacement.template + (reason == null ? ")" : ", #{any(java.lang.String)})");
                    JavaTemplate template = JavaTemplate.builder((String)templateString).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).staticImports(new String[]{"org.junit.jupiter.api.Assertions." + assertion}).build();
                    this.maybeRemoveImport("org.hamcrest.Matchers." + replacement.hamcrest);
                    this.maybeRemoveImport("org.hamcrest.CoreMatchers." + replacement.hamcrest);
                    this.maybeAddImport("org.junit.jupiter.api.Assertions", assertion);
                    List arguments = (List)((BiFunction)Replacement.methods.get(replacement.argumentsMethod)).apply(examinedObject, matcherInvocation);
                    if (reason != null) {
                        arguments.add(reason);
                    }
                    return (J.MethodInvocation)template.apply(this.getCursor(), method.getCoordinates().replace(), arguments.toArray());
                }
            }
            return mi;
        }
    }

    static enum Replacement {
        EQUALTO("equalTo", "assertEquals", "assertNotEquals", "#{any(java.lang.Object)}, #{any(java.lang.Object)}", "examinedObjThenMatcherArgs"),
        EMPTYARRAY("emptyArray", "assertEquals", "assertNotEquals", "0, #{anyArray(java.lang.Object)}.length", "examinedObjOnly"),
        HASENTRY("hasEntry", "assertEquals", "assertNotEquals", "#{any(java.lang.Object)}, #{any(java.util.Map)}.get(#{any(java.lang.Object)})", "matcher1ExaminedObjMatcher0"),
        HASSIZE("hasSize", "assertEquals", "assertNotEquals", "#{any(java.util.Collection)}.size(), #{any(double)}", "examinedObjThenMatcherArgs"),
        HASTOSTRING("hasToString", "assertEquals", "assertNotEquals", "#{any(java.lang.Object)}.toString(), #{any(java.lang.String)}", "examinedObjThenMatcherArgs"),
        CLOSETO("closeTo", "assertTrue", "assertFalse", "Math.abs(#{any(double)} - #{any(double)}) < #{any(double)}", "examinedObjThenMatcherArgs"),
        CONTAINSSTRING("containsString", "assertTrue", "assertFalse", "#{any(java.lang.String)}.contains(#{any(java.lang.String)}", "examinedObjThenMatcherArgs"),
        EMPTY("empty", "assertTrue", "assertFalse", "#{any(java.util.Collection)}.isEmpty()", "examinedObjOnly"),
        ENDSWITH("endsWith", "assertTrue", "assertFalse", "#{any(java.lang.String)}.endsWith(#{any(java.lang.String)})", "examinedObjThenMatcherArgs"),
        EQUALTOIGNORINGCASE("equalToIgnoringCase", "assertTrue", "assertFalse", "#{any(java.lang.String)}.equalsIgnoreCase(#{any(java.lang.String)})", "examinedObjThenMatcherArgs"),
        GREATERTHAN("greaterThan", "assertTrue", "assertFalse", "#{any(double)} > #{any(double)}", "examinedObjThenMatcherArgs"),
        GREATERTHANOREQUALTO("greaterThanOrEqualTo", "assertTrue", "assertFalse", "#{any(double)} >= #{any(double)}", "examinedObjThenMatcherArgs"),
        HASKEY("hasKey", "assertTrue", "assertFalse", "#{any(java.util.Map)}.containsKey(#{any(java.lang.Object)})", "examinedObjThenMatcherArgs"),
        HASVALUE("hasValue", "assertTrue", "assertFalse", "#{any(java.util.Map)}.containsValue(#{any(java.lang.Object)})", "examinedObjThenMatcherArgs"),
        LESSTHAN("lessThan", "assertTrue", "assertFalse", "#{any(double)} < #{any(double)}", "examinedObjThenMatcherArgs"),
        LESSTHANOREQUALTO("lessThanOrEqualTo", "assertTrue", "assertFalse", "#{any(double)} <= #{any(double)}", "examinedObjThenMatcherArgs"),
        STARTSWITH("startsWith", "assertTrue", "assertFalse", "#{any(java.lang.String)}.startsWith(#{any(java.lang.String)})", "examinedObjThenMatcherArgs"),
        TYPECOMPATIBLEWITH("typeCompatibleWith", "assertTrue", "assertFalse", "#{any(java.lang.Class)}.isAssignableFrom(#{any(java.lang.Class)})", "matcherArgsThenExaminedObj"),
        NOTNULLVALUE("notNullValue", "assertNotNull", "assertNull", "#{any(java.lang.Object)}", "examinedObjOnly"),
        NULLVALUE("nullValue", "assertNull", "assertNotNull", "#{any(java.lang.Object)}", "examinedObjOnly"),
        SAMEINSTANCE("sameInstance", "assertSame", "assertNotSame", "#{any(java.lang.Object)}, #{any(java.lang.Object)}", "examinedObjThenMatcherArgs"),
        THEINSTANCE("theInstance", "assertSame", "assertNotSame", "#{any(java.lang.Object)}, #{any(java.lang.Object)}", "examinedObjThenMatcherArgs"),
        EMPTYITERABLE("emptyIterable", "assertFalse", "assertTrue", "#{any(java.lang.Iterable)}.iterator().hasNext()", "examinedObjOnly");

        final String hamcrest;
        final String junitPositive;
        final String junitNegative;
        final String template;
        final String argumentsMethod;
        private static final Map<String, BiFunction<Expression, J.MethodInvocation, List<Expression>>> methods;

        private Replacement(String hamcrest, String junitPositive, String junitNegative, String template, String argumentsMethod) {
            this.hamcrest = hamcrest;
            this.junitPositive = junitPositive;
            this.junitNegative = junitNegative;
            this.template = template;
            this.argumentsMethod = argumentsMethod;
        }

        static {
            methods = new HashMap<String, BiFunction<Expression, J.MethodInvocation, List<Expression>>>();
            methods.put("examinedObjThenMatcherArgs", (ex, matcher) -> {
                List arguments = matcher.getArguments();
                arguments.add(0, ex);
                return arguments;
            });
            methods.put("matcherArgsThenExaminedObj", (ex, matcher) -> {
                List arguments = matcher.getArguments();
                arguments.add(ex);
                return arguments;
            });
            methods.put("examinedObjOnly", (ex, matcher) -> {
                ArrayList<Expression> arguments = new ArrayList<Expression>();
                arguments.add((Expression)ex);
                return arguments;
            });
            methods.put("matcher1ExaminedObjMatcher0", (ex, matcher) -> {
                ArrayList<Expression> arguments = new ArrayList<Expression>();
                arguments.add((Expression)matcher.getArguments().get(1));
                arguments.add((Expression)ex);
                arguments.add((Expression)matcher.getArguments().get(0));
                return arguments;
            });
        }
    }
}

