/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.Comparator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.trait.Annotated;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class EnvironmentVariables
extends Recipe {
    public static final String ENVIRONMENT_VARIABLES = "org.junit.contrib.java.lang.system.EnvironmentVariables";
    public static final String ENVIRONMENT_VARIABLES_STUB = "uk.org.webcompere.systemstubs.environment.EnvironmentVariables";
    public static final String SYSTEM_STUBS_EXTENSION = "uk.org.webcompere.systemstubs.jupiter.SystemStubsExtension";
    public static final String SYSTEM_STUB = "uk.org.webcompere.systemstubs.jupiter.SystemStub";
    private static final String EXTEND_WITH = "org.junit.jupiter.api.extension.ExtendWith";

    public @NonNull String getDisplayName() {
        return "Migrate JUnit 4 environmentVariables rule to JUnit 5 system stubs extension";
    }

    public @NonNull String getDescription() {
        return "Replaces usage of the JUnit 4 `@Rule EnvironmentVariables` with the JUnit 5-compatible `SystemStubsExtension` and `@SystemStub EnvironmentVariables` from the System Stubs library.";
    }

    public @NonNull TreeVisitor<?, ExecutionContext> getVisitor() {
        return new EnvironmentVariablesVisitor();
    }

    private static class EnvironmentVariablesVisitor
    extends JavaVisitor<ExecutionContext> {
        private static final String HAS_ENV_VAR_RULE = "hasEnvVarRule";
        private static final MethodMatcher ENV_VAR_CLEAR = new MethodMatcher("org.junit.contrib.java.lang.system.EnvironmentVariables clear(String[])");

        private EnvironmentVariablesVisitor() {
        }

        public @NonNull J visitCompilationUnit(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull J.CompilationUnit cu, @NonNull ExecutionContext ctx) {
            this.maybeRemoveImport("org.junit.Rule");
            this.maybeRemoveImport("org.junit.ClassRule");
            this.maybeRemoveImport(EnvironmentVariables.ENVIRONMENT_VARIABLES);
            this.maybeAddImport(EnvironmentVariables.SYSTEM_STUBS_EXTENSION);
            this.maybeAddImport(EnvironmentVariables.SYSTEM_STUB);
            this.maybeAddImport(EnvironmentVariables.EXTEND_WITH);
            this.maybeAddImport(EnvironmentVariables.ENVIRONMENT_VARIABLES_STUB);
            return super.visitCompilationUnit(cu, (Object)ctx);
        }

        public @NonNull J visitClassDeclaration(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull J.ClassDeclaration classDecl, @NonNull ExecutionContext ctx) {
            J.ClassDeclaration cd = (J.ClassDeclaration)super.visitClassDeclaration(classDecl, (Object)ctx);
            Boolean hasEnvVarRule = (Boolean)this.getCursor().getMessage(HAS_ENV_VAR_RULE);
            if (!Boolean.TRUE.equals(hasEnvVarRule)) {
                return cd;
            }
            return EnvironmentVariablesVisitor.systemStubExtensionTemplate(ctx).apply(this.updateCursor((Tree)cd), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
        }

        public @NonNull J visitVariableDeclarations(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull J.VariableDeclarations variableDecls, @NonNull ExecutionContext ctx) {
            if (variableDecls.getType() == null || !TypeUtils.isAssignableTo((String)EnvironmentVariables.ENVIRONMENT_VARIABLES, (JavaType)variableDecls.getType())) {
                return variableDecls;
            }
            J.VariableDeclarations vd = (J.VariableDeclarations)new Annotated.Matcher("@org.junit.*Rule").asVisitor(a -> new JavaIsoVisitor<ExecutionContext>(){

                public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                    return (J.Annotation)EnvironmentVariablesVisitor.systemStubsTemplate(ctx).apply(this.updateCursor((Tree)annotation), annotation.getCoordinates().replace(), new Object[0]);
                }
            }.visit(a.getTree(), (Object)ctx, a.getCursor().getParentOrThrow())).visit((Tree)variableDecls, (Object)ctx, this.getCursor().getParentOrThrow());
            if (variableDecls != vd) {
                this.getCursor().dropParentUntil(c -> c instanceof J.ClassDeclaration).putMessage(HAS_ENV_VAR_RULE, (Object)true);
            }
            return super.visitVariableDeclarations(vd, (Object)ctx);
        }

        public @Nullable J visitMethodInvocation(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull J.MethodInvocation method, @NonNull ExecutionContext ctx) {
            J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
            if (ENV_VAR_CLEAR.matches((MethodCall)method) && m.getSelect() != null) {
                int argCount = EnvironmentVariablesVisitor.argCount(m);
                J j = EnvironmentVariablesVisitor.getEnvVarClearTemplate(ctx, argCount).apply(this.updateCursor((Tree)m), m.getCoordinates().replace(), (Object[])EnvironmentVariablesVisitor.getArgs(m, argCount));
                if (this.getCursor().getParentTreeCursor().getValue() instanceof J.Block && !(j instanceof Statement)) {
                    return null;
                }
                return j;
            }
            return m;
        }

        public @Nullable JavaType visitType(@Nullable JavaType type, @NonNull ExecutionContext ctx) {
            String fullyQualifiedName;
            if (type instanceof JavaType.FullyQualified && EnvironmentVariables.ENVIRONMENT_VARIABLES.equals(fullyQualifiedName = ((JavaType.FullyQualified)type).getFullyQualifiedName())) {
                return JavaType.buildType((String)EnvironmentVariables.ENVIRONMENT_VARIABLES_STUB);
            }
            return super.visitType(type, (Object)ctx);
        }

        private static JavaTemplate systemStubExtensionTemplate(ExecutionContext ctx) {
            return JavaTemplate.builder((String)"@ExtendWith(SystemStubsExtension.class)").imports(new String[]{EnvironmentVariables.EXTEND_WITH, EnvironmentVariables.SYSTEM_STUBS_EXTENSION}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"system-stubs-jupiter", "junit-jupiter-api"})).build();
        }

        private static JavaTemplate systemStubsTemplate(ExecutionContext ctx) {
            return JavaTemplate.builder((String)"@SystemStub").imports(new String[]{EnvironmentVariables.SYSTEM_STUB}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"system-stubs-jupiter"})).build();
        }

        private static JavaTemplate getEnvVarClearTemplate(ExecutionContext ctx, int argsSize) {
            StringBuilder template = new StringBuilder("#{any(").append(EnvironmentVariables.ENVIRONMENT_VARIABLES_STUB).append(")}");
            for (int i = 0; i < argsSize; ++i) {
                template.append(".remove(#{any(java.lang.String)})");
            }
            return JavaTemplate.builder((String)template.toString()).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"system-stubs-jupiter", "system-stubs-core"})).build();
        }

        private static int argCount(J.MethodInvocation methodInvocation) {
            if (methodInvocation.getArguments().size() == 1) {
                return methodInvocation.getArguments().get(0) instanceof J.Empty ? 0 : 1;
            }
            return methodInvocation.getArguments().size();
        }

        private static Expression[] getArgs(J.MethodInvocation methodInvocation, int argCount) {
            Expression[] args = new Expression[argCount + 1];
            args[0] = methodInvocation.getSelect();
            for (int i = 0; i < argCount; ++i) {
                args[i + 1] = (Expression)methodInvocation.getArguments().get(i);
            }
            return args;
        }
    }
}

