/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class RemoveTestPrefix
extends Recipe {
    private static final List<String> RESERVED_KEYWORDS = Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "null", "clone", "finalize", "hashCode", "notify", "notifyAll", "toString", "wait");

    public String getDisplayName() {
        return "Remove `test` prefix from JUnit 5 tests";
    }

    public String getDescription() {
        return "Remove `test` from methods with `@Test`, `@ParameterizedTest`, `@RepeatedTest` or `@TestFactory`. They no longer have to prefix test to be usable by JUnit 5.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.junit.jupiter.api.Test", Boolean.valueOf(false)), new UsesType("org.junit.jupiter.api.TestTemplate", Boolean.valueOf(false)), new UsesType("org.junit.jupiter.api.RepeatedTest", Boolean.valueOf(false)), new UsesType("org.junit.jupiter.params.ParameterizedTest", Boolean.valueOf(false)), new UsesType("org.junit.jupiter.api.TestFactory", Boolean.valueOf(false))}), (TreeVisitor)new RemoveTestPrefixVisitor());
    }

    private static class RemoveTestPrefixVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final AnnotationMatcher ANNOTATION_MATCHER = new AnnotationMatcher("@org.junit.jupiter.params.provider.MethodSource");

        private RemoveTestPrefixVisitor() {
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            String newMethodName;
            boolean snakecase;
            J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
            String simpleName = method.getSimpleName();
            int nameLength = simpleName.length();
            if (nameLength < 5 || !simpleName.startsWith("test") || simpleName.charAt(4) != '_' && !Character.isUpperCase(simpleName.charAt(4)) || TypeUtils.isOverride((JavaType.Method)method.getMethodType()) || !RemoveTestPrefixVisitor.hasJUnit5MethodAnnotation(method)) {
                return m;
            }
            boolean bl = snakecase = simpleName.charAt(4) == '_' && 5 < nameLength && Character.isAlphabetic(simpleName.charAt(5));
            if (!snakecase && !Character.isAlphabetic(simpleName.charAt(4))) {
                return m;
            }
            String string = newMethodName = snakecase ? NameCaseConvention.format((NameCaseConvention)NameCaseConvention.LOWER_UNDERSCORE, (String)simpleName.substring(5)) : NameCaseConvention.format((NameCaseConvention)NameCaseConvention.LOWER_CAMEL, (String)simpleName.substring(4));
            if (RESERVED_KEYWORDS.contains(newMethodName)) {
                return m;
            }
            JavaType.Method type = m.getMethodType();
            if (type == null || this.methodExists(type, newMethodName)) {
                return m;
            }
            for (J.Annotation annotation : method.getLeadingAnnotations()) {
                if (!ANNOTATION_MATCHER.matches(annotation) || annotation.getArguments() != null && !annotation.getArguments().isEmpty()) continue;
                return m;
            }
            final AtomicBoolean skip = new AtomicBoolean(false);
            new JavaIsoVisitor<AtomicBoolean>(){

                public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, AtomicBoolean atomicBoolean) {
                    if (method.getName().getSimpleName().equals(newMethodName) && method.getSelect() == null) {
                        skip.set(true);
                    }
                    return super.visitMethodInvocation(method, (Object)atomicBoolean);
                }
            }.visitMethodDeclaration(m, (Object)skip);
            if (skip.get()) {
                return m;
            }
            this.doAfterVisit(new ChangeMethodName(MethodMatcher.methodPattern((J.MethodDeclaration)m), newMethodName, Boolean.valueOf(false), Boolean.valueOf(false)).getVisitor());
            return m;
        }

        private boolean methodExists(JavaType.Method method, String newName) {
            return TypeUtils.findDeclaredMethod((JavaType.FullyQualified)method.getDeclaringType(), (String)newName, (List)method.getParameterTypes()).orElse(null) != null;
        }

        private static boolean hasJUnit5MethodAnnotation(J.MethodDeclaration method) {
            for (J.Annotation a : method.getLeadingAnnotations()) {
                if (!TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.Test") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.TestTemplate") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.RepeatedTest") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.params.ParameterizedTest") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.TestFactory")) continue;
                return true;
            }
            return false;
        }
    }
}

