/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public class UpdateBeforeAfterAnnotations
extends Recipe {
    public String getDisplayName() {
        return "Migrate JUnit 4 lifecycle annotations to JUnit Jupiter";
    }

    public String getDescription() {
        return "Replace JUnit 4's `@Before`, `@BeforeClass`, `@After`, and `@AfterClass` annotations with their JUnit Jupiter equivalents.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.junit.BeforeClass", Boolean.valueOf(false)), new UsesType("org.junit.Before", Boolean.valueOf(false)), new UsesType("org.junit.After", Boolean.valueOf(false)), new UsesType("org.junit.AfterClass", Boolean.valueOf(false))}), (TreeVisitor)new UpdateBeforeAfterAnnotationsVisitor());
    }

    public static class UpdateBeforeAfterAnnotationsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        public J preVisit(J tree, ExecutionContext ctx) {
            this.stopAfterPreVisit();
            this.doAfterVisit(new ChangeType("org.junit.Before", "org.junit.jupiter.api.BeforeEach", Boolean.valueOf(true), null).getVisitor());
            this.doAfterVisit(new ChangeType("org.junit.After", "org.junit.jupiter.api.AfterEach", Boolean.valueOf(true), null).getVisitor());
            this.doAfterVisit(new ChangeType("org.junit.BeforeClass", "org.junit.jupiter.api.BeforeAll", Boolean.valueOf(true), null).getVisitor());
            this.doAfterVisit(new ChangeType("org.junit.AfterClass", "org.junit.jupiter.api.AfterAll", Boolean.valueOf(true), null).getVisitor());
            return tree;
        }
    }
}

