/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.testing.junit5.FileOrFolder;
import org.openrewrite.java.testing.junit5.TranslateNewFolderOrFileMethodInvocation;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

class AddNewFolderOrFileMethod
extends JavaIsoVisitor<ExecutionContext> {
    private final J.MethodInvocation methodInvocation;
    private final FileOrFolder fileOrFolder;

    private boolean hasClassType(Statement j, @Nullable String classType) {
        if (classType == null) {
            return false;
        }
        if (!(j instanceof J.VariableDeclarations)) {
            return false;
        }
        J.VariableDeclarations variable = (J.VariableDeclarations)j;
        if (variable.getTypeExpression() == null) {
            return false;
        }
        return TypeUtils.isOfClassType((JavaType)variable.getTypeExpression().getType(), (String)classType);
    }

    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
        J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
        JavaType.Method newMethodDeclaration = this.getMethodDeclaration(cd, this.fileOrFolder).orElse(null);
        if (newMethodDeclaration == null) {
            cd = (J.ClassDeclaration)JavaTemplate.builder((String)this.fileOrFolder.template).contextSensitive().imports(new String[]{"java.io.File", "java.io.IOException"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).build().apply(this.updateCursor((Tree)cd), cd.getBody().getCoordinates().lastStatement(), new Object[0]);
            newMethodDeclaration = ((J.MethodDeclaration)cd.getBody().getStatements().get(cd.getBody().getStatements().size() - 1)).getMethodType();
            this.maybeAddImport("java.io.File");
            this.maybeAddImport("java.io.IOException");
        }
        assert (newMethodDeclaration != null);
        this.doAfterVisit((TreeVisitor)new TranslateNewFolderOrFileMethodInvocation(this.methodInvocation, newMethodDeclaration, this.fileOrFolder));
        return cd;
    }

    private Optional<JavaType.Method> getMethodDeclaration(J.ClassDeclaration cd, FileOrFolder fileOrFolder) {
        return cd.getBody().getStatements().stream().filter(J.MethodDeclaration.class::isInstance).map(J.MethodDeclaration.class::cast).filter(m -> {
            List params = m.getParameters();
            return fileOrFolder.methodName.equals(m.getSimpleName()) && params.size() == 2 && this.hasClassType((Statement)params.get(0), "java.io.File") && this.hasClassType((Statement)params.get(1), "java.lang.String");
        }).map(J.MethodDeclaration::getMethodType).filter(Objects::nonNull).findAny();
    }

    @ConstructorProperties(value={"methodInvocation", "fileOrFolder"})
    @Generated
    public AddNewFolderOrFileMethod(J.MethodInvocation methodInvocation, FileOrFolder fileOrFolder) {
        this.methodInvocation = methodInvocation;
        this.fileOrFolder = fileOrFolder;
    }
}

