/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJCharSequenceRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJCharSequenceRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJCharSequenceRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AssertThatCharSequenceHasSizeRecipe()});
    }

    @NonNullApi
    public static class AssertThatCharSequenceHasSizeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJCharSequenceRules.AssertThatCharSequenceHasSize`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatCharSequenceHasSize {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(CharSequence charSequence, int length) {\n        return assertThat(charSequence.length()).isEqualTo(length);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractAssert<?, ?> after(CharSequence charSequence, int length) {\n        return assertThat(charSequence).hasSize(length);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (charSequence, length) -> Assertions.assertThat((int)charSequence.length()).isEqualTo(length)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (charSequence, length) -> Assertions.assertThat((CharSequence)charSequence).hasSize(length.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isEqualTo(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)"), new UsesMethod("java.lang.CharSequence length(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

